/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import com.xiaohunao.equipment_benediction.common.hook.HookMapManager;
import com.xiaohunao.equipment_benediction.common.hook.HookType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.mod.api.event.AdditionalManaEvent;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModHookTypes;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.util.EnchantmentUtils;
import org.confluence.mod.util.FloatSupplier;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.ApiStatus;

public class ManaStorage
implements INBTSerializable<CompoundTag> {
    private int stars = 1;
    private int additionalMana = 0;
    private float currentMana = 20.0f;
    private transient int regenerateDelay = 0;
    private transient int maxMana = -1;
    private boolean fastManaRegeneration = false;
    private boolean arcaneCrystalUsed = false;

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("stars", this.stars);
        nbt.putInt("additionalMana", this.additionalMana);
        nbt.putFloat("currentMana", this.currentMana);
        nbt.putBoolean("fastManaRegeneration", this.fastManaRegeneration);
        nbt.putBoolean("arcaneCrystalUsed", this.arcaneCrystalUsed);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stars = nbt.getInt("stars");
        this.additionalMana = nbt.getInt("additionalMana");
        this.currentMana = nbt.getInt("currentMana");
        this.fastManaRegeneration = nbt.getBoolean("fastManaRegeneration");
        this.arcaneCrystalUsed = nbt.getBoolean("arcaneCrystalUsed");
    }

    public boolean receiveMana(FloatSupplier sup) {
        if (!this.canReceive()) {
            return false;
        }
        this.currentMana = Math.min((float)this.getMaxMana(), sup.getAsFloat() + this.currentMana);
        return true;
    }

    public boolean extractMana(FloatSupplier sup, ServerPlayer serverPlayer) {
        if (!this.canExtract()) {
            return false;
        }
        float extract = sup.getAsFloat() * (1.0f - ((Float)TCUtils.getAccessoriesValue((LivingEntity)serverPlayer, AccessoryItems.MANA$USE$REDUCE)).floatValue());
        if (PlayerUtils.applyAutoGetMana(serverPlayer, this.currentMana, extract)) {
            return false;
        }
        this.currentMana -= extract;
        if (extract > 0.0f) {
            this.setRegenerateDelay();
        }
        EnchantmentUtils.repairPlayerItems(serverPlayer, extract);
        return true;
    }

    public boolean forceExtractMana(FloatSupplier sup) {
        if (!this.canExtract()) {
            return false;
        }
        float extract = sup.getAsFloat();
        if (this.currentMana < extract) {
            return false;
        }
        this.currentMana -= extract;
        if (extract > 0.0f) {
            this.setRegenerateDelay();
        }
        return true;
    }

    public float getCurrentMana() {
        return this.currentMana;
    }

    public int getRegenerateDelay() {
        return this.regenerateDelay;
    }

    public void setRegenerateDelay(int regenerateDelay) {
        this.regenerateDelay = regenerateDelay;
    }

    public void setRegenerateDelay() {
        this.regenerateDelay = Mth.ceil((float)(0.7f * ((1.0f - this.currentMana / (float)this.getMaxMana()) * 240.0f + 45.0f)));
    }

    public int getMaxMana() {
        if (this.maxMana < 0) {
            this.freshMaxMana();
        }
        return this.maxMana;
    }

    public void freshMaxMana() {
        this.maxMana = this.stars * 20 + this.additionalMana;
        if (this.currentMana > (float)this.maxMana) {
            this.currentMana = this.maxMana;
        }
    }

    public boolean canExtract() {
        return this.currentMana > 0.0f;
    }

    public boolean canReceive() {
        return this.currentMana < (float)this.getMaxMana();
    }

    public boolean addStar() {
        if (!this.isStarMaximum()) {
            ++this.stars;
            this.freshMaxMana();
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public void clearStars() {
        this.stars = 1;
        this.freshMaxMana();
    }

    public boolean isStarMaximum() {
        return this.stars >= 10;
    }

    public void flushAbility(ServerPlayer serverPlayer) {
        int posted;
        AdditionalManaEvent event;
        this.fastManaRegeneration = TCUtils.hasAccessoriesType((LivingEntity)serverPlayer, AccessoryItems.FAST$MANA$GENERATION);
        int value = (Integer)TCUtils.getAccessoriesValue((LivingEntity)serverPlayer, AccessoryItems.ADDITIONAL$MANA);
        if (serverPlayer.hasEffect(ModEffects.CLAIRVOYANCE)) {
            value += 20;
        }
        if (!(event = (AdditionalManaEvent)NeoForge.EVENT_BUS.post((Event)new AdditionalManaEvent((Player)serverPlayer, this, posted = ((Integer)HookMapManager.postHooks((HookType)((HookType)ModHookTypes.ADDITIONAL_MANA.get()), (owner, hook, original) -> hook.additional(owner, (Player)serverPlayer, (int)original), (Entity)serverPlayer, (Object)value)).intValue(), this.additionalMana))).isCanceled() && event.getNeoValue() != this.additionalMana) {
            this.additionalMana = event.getNeoValue();
            this.freshMaxMana();
            PlayerUtils.syncMana2Client(serverPlayer, this);
        }
    }

    public boolean isFastManaRegeneration() {
        return this.fastManaRegeneration;
    }

    public boolean setArcaneCrystalUsed() {
        if (this.arcaneCrystalUsed) {
            return false;
        }
        this.arcaneCrystalUsed = true;
        return true;
    }

    public boolean isArcaneCrystalUsed() {
        return this.arcaneCrystalUsed;
    }

    public static ManaStorage of(LivingEntity living) {
        return (ManaStorage)living.getData(ModAttachmentTypes.MANA_STORAGE);
    }
}

