/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import com.google.common.collect.Iterables;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;

public class PlayerSpecialData
implements INBTSerializable<CompoundTag> {
    private ItemStack currentQuestedFish = ItemStack.EMPTY;
    private ITradeLock currentQuestedFishCondition = ITradeLock.alwaysTrue();
    private boolean couldHurtCritters = true;
    private boolean couldDamageEnvironment = true;

    public void setCurrentQuestedFish(ItemStack cost, ITradeLock lock) {
        this.currentQuestedFish = cost;
        this.currentQuestedFishCondition = lock;
    }

    public void removeCurrentQuestedFish() {
        this.setCurrentQuestedFish(ItemStack.EMPTY, ITradeLock.alwaysTrue());
    }

    public ItemStack getCurrentQuestedFish(Player player) {
        if (this.currentQuestedFishCondition.canTrade(player, ITradeHolder.dummy((Player)player), 0)) {
            return this.currentQuestedFish;
        }
        return ItemStack.EMPTY;
    }

    public void setCouldHurtCritters(boolean couldHurtCritters) {
        this.couldHurtCritters = couldHurtCritters;
    }

    public boolean isCouldHurtCritters() {
        return this.couldHurtCritters;
    }

    public void setCouldDamageEnvironment(boolean couldDamageEnvironment) {
        this.couldDamageEnvironment = couldDamageEnvironment;
    }

    public boolean isCouldDamageEnvironment() {
        return this.couldDamageEnvironment;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag tag = new CompoundTag();
        tag.put("CurrentQuestedFish", ItemStack.OPTIONAL_CODEC.encodeStart((DynamicOps)ops, (Object)this.currentQuestedFish).result().orElseGet(CompoundTag::new));
        tag.put("CurrentQuestedFishCondition", ITradeLock.TYPED_CODEC.encodeStart((DynamicOps)ops, (Object)this.currentQuestedFishCondition).result().orElseGet(CompoundTag::new));
        tag.putBoolean("CouldHurtCritters", this.couldHurtCritters);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.currentQuestedFish = ItemStack.OPTIONAL_CODEC.parse((DynamicOps)ops, (Object)nbt.get("CurrentQuestedFish")).result().orElse(ItemStack.EMPTY);
        this.currentQuestedFishCondition = ITradeLock.TYPED_CODEC.parse((DynamicOps)ops, (Object)nbt.get("CurrentQuestedFishCondition")).result().orElse(ITradeLock.alwaysTrue());
        this.couldHurtCritters = nbt.getBoolean("CouldHurtCritters");
    }

    public static PlayerSpecialData of(Player player) {
        return (PlayerSpecialData)player.getData(ModAttachmentTypes.SPECIAL_DATA);
    }

    public static void resetSomeData(Player player) {
        PlayerSpecialData data = PlayerSpecialData.of(player);
        if (!data.isCouldHurtCritters() || !data.isCouldDamageEnvironment()) {
            data.setCouldHurtCritters(true);
            data.setCouldDamageEnvironment(true);
            for (ItemStack stack : Iterables.concat((Iterable)player.getInventory().offhand, (Iterable)player.getInventory().items)) {
                boolean c;
                boolean a = data.isCouldHurtCritters();
                boolean b = data.isCouldDamageEnvironment();
                if (!a && !b) break;
                Item item = stack.getItem();
                boolean bl = c = item == ToolItems.GUIDE_TO_PEACEFUL_COEXISTENCE.get();
                if (a && (c || item == ToolItems.GUIDE_TO_CRITTER_COMPANIONSHIP.get())) {
                    data.setCouldHurtCritters(false);
                }
                if (!b || !c && item != ToolItems.GUIDE_TO_ENVIRONMENTAL_PRESERVATION.get()) continue;
                data.setCouldDamageEnvironment(false);
            }
        }
    }
}

