/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.jetbrains.annotations.Nullable;

public class BaseChestBlock
extends ChestBlock {
    public static final BooleanProperty UNLOCKED = StateProperties.UNLOCKED;
    @Nullable
    private final Key key;

    public BaseChestBlock(@Nullable Key key) {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHEST), ChestBlocks.BASE_CHEST_ENTITY::get, key);
    }

    public BaseChestBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, @Nullable Key key) {
        super(properties, supplier);
        this.key = key;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(key == null)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{UNLOCKED}));
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BEntity(pPos, pState);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ItemStack stack = this.asItem().getDefaultInstance();
        stack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(Map.of("unlocked", (Boolean)state.getValue((Property)UNLOCKED) != false ? "true" : "false")));
        return Collections.singletonList(stack);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false ? super.getExplosionResistance(state, level, pos, explosion) : 18000.0f;
    }

    @Nullable
    protected Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        if (blockstate.is((Block)this) && ((Boolean)blockstate.getValue((Property)UNLOCKED)).booleanValue() == this.unlocked(context.getItemInHand())) {
            return blockstate.getValue((Property)TYPE) == ChestType.SINGLE ? (Direction)blockstate.getValue((Property)FACING) : null;
        }
        return null;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)UNLOCKED, (Comparable)Boolean.valueOf(this.unlocked(context.getItemInHand())));
    }

    protected boolean unlocked(ItemStack stack) {
        return ((BlockItemStateProperties)stack.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY)).properties().getOrDefault("unlocked", "true").equals("true");
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)UNLOCKED)).booleanValue()) {
            if (this.key != null && !this.key.useKeyOn(stack, state, level, pos, player, hand, hitResult)) {
                return ItemInteractionResult.FAIL;
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        stack.set(DataComponents.BLOCK_STATE, (Object)new BlockItemStateProperties(Map.of("unlocked", (Boolean)state.getValue((Property)UNLOCKED) != false ? "true" : "false")));
        return stack;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false && super.canEntityDestroy(state, level, pos, entity);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)UNLOCKED) != false ? super.getDestroyProgress(state, player, level, pos) : 0.0f;
    }

    @FunctionalInterface
    public static interface Key {
        public boolean useKeyOn(ItemStack var1, BlockState var2, Level var3, BlockPos var4, Player var5, InteractionHand var6, BlockHitResult var7);
    }

    public static class BEntity
    extends ChestBlockEntity {
        public BEntity(BlockPos pPos, BlockState pBlockState) {
            this(ChestBlocks.BASE_CHEST_ENTITY.get(), pPos, pBlockState);
        }

        public BEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
            super(pType, pPos, pBlockState);
        }

        protected Component getDefaultName() {
            return this.getBlockState().getBlock().getName();
        }

        public boolean canOpen(Player pPlayer) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED) != false && super.canOpen(pPlayer);
        }

        public boolean canTakeItem(Container target, int slot, ItemStack stack) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return (Boolean)this.getBlockState().getValue((Property)UNLOCKED);
        }
    }
}

