/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModTags;
import org.jetbrains.annotations.NotNull;

public class BaseRopeBlock
extends PipeBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BaseRopeBlock> CODEC = BaseRopeBlock.simpleCodec(BaseRopeBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public BaseRopeBlock(BlockBehaviour.Properties properties) {
        super(0.25f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    protected MapCodec<BaseRopeBlock> codec() {
        return CODEC;
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @NotNull
    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(BaseRopeBlock.shouldConnect(level, facingState, facingPos, facing)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState belowState = level.getBlockState(pos);
        if (belowState.getFluidState().is((Fluid)Fluids.WATER)) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        for (Direction direction : LibUtils.DIRECTIONS) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (!BaseRopeBlock.shouldConnect((LevelAccessor)level, neighborState, neighborPos, direction)) continue;
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    private static boolean shouldConnect(LevelAccessor level, BlockState facingState, BlockPos facingPos, Direction facing) {
        return facingState.is(ModTags.Blocks.ROPE) || !facingState.isAir() && facingState.isFaceSturdy((BlockGetter)level, facingPos, facing.getOpposite());
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ecc;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ecc = (EntityCollisionContext)context).getEntity()) instanceof Player) {
            BlockPos blockPos = entity.blockPosition().atY((int)entity.getEyeY());
            if (level.getBlockState(blockPos).is(ModTags.Blocks.ROPE) || level.getBlockState(blockPos.below()).is(ModTags.Blocks.ROPE)) {
                return Shapes.empty();
            }
            return super.getShape(state, level, pos, context);
        }
        return Shapes.empty();
    }

    public static class BItem
    extends BlockItem {
        public BItem(Block block) {
            super(block, new Item.Properties());
        }

        public InteractionResult place(BlockPlaceContext context) {
            Player player = context.getPlayer();
            if (player == null || player.isCrouching()) {
                return super.place(context);
            }
            Level level = context.getLevel();
            BlockHitResult hitResult = context.getHitResult();
            BlockPos.MutableBlockPos relative = hitResult.getBlockPos().mutable();
            while (level.getBlockState((BlockPos)relative).is(ModTags.Blocks.ROPE)) {
                relative.move(0, -1, 0);
            }
            BlockHitResult hitResult1 = new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), (BlockPos)relative, hitResult.isInside());
            InteractionResult place = super.place(new BlockPlaceContext(level, player, context.getHand(), context.getItemInHand(), hitResult1));
            if (place == InteractionResult.FAIL) {
                return super.place(context);
            }
            return place;
        }
    }
}

