/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.jetbrains.annotations.Nullable;

public class MuralBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<MuralBlock> CODEC = MuralBlock.simpleCodec(MuralBlock::new);

    public MuralBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.WEST));
    }

    protected MapCodec<MuralBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    public static class BEntity
    extends BlockEntity {
        private Optional<List<MuralData>> back = Optional.empty();
        private Optional<List<MuralData>> left = Optional.empty();
        private Optional<List<MuralData>> right = Optional.empty();
        private Optional<List<MuralData>> front = Optional.empty();

        public BEntity(BlockPos pos, BlockState blockState) {
            super(DecorativeBlocks.MURAL_ENTITY_BLOCK.get(), pos, blockState);
        }

        public Optional<List<MuralData>> getBack() {
            return this.back;
        }

        public Optional<List<MuralData>> getLeft() {
            return this.left;
        }

        public Optional<List<MuralData>> getRight() {
            return this.right;
        }

        public Optional<List<MuralData>> getFront() {
            return this.front;
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            this.encode(tag, registries);
            return tag;
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
            this.decode(tag, registries);
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.decode(tag, registries);
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.encode(tag, registries);
        }

        private void encode(CompoundTag tag, HolderLookup.Provider registries) {
            tag.put("back", MuralData.encode(this.back, registries));
            tag.put("left", MuralData.encode(this.left, registries));
            tag.put("right", MuralData.encode(this.right, registries));
            tag.put("front", MuralData.encode(this.front, registries));
        }

        private void decode(CompoundTag tag, HolderLookup.Provider registries) {
            this.back = MuralData.decode(tag.getList("back", 10), registries);
            this.left = MuralData.decode(tag.getList("left", 10), registries);
            this.right = MuralData.decode(tag.getList("right", 10), registries);
            this.front = MuralData.decode(tag.getList("front", 10), registries);
        }

        @Nullable
        public Packet<ClientGamePacketListener> getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }
    }

    public record Text(Component component, float x, float y, int color, int backgroundColor, boolean dropShadow) {
        public static final Codec<Text> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("component").forGetter(Text::component), (App)Codec.FLOAT.lenientOptionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(Text::x), (App)Codec.FLOAT.lenientOptionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(Text::y), (App)Codec.INT.lenientOptionalFieldOf("color", (Object)-1).forGetter(Text::color), (App)Codec.INT.lenientOptionalFieldOf("backgroundColor", (Object)0).forGetter(Text::backgroundColor), (App)Codec.BOOL.lenientOptionalFieldOf("dropShadow", (Object)false).forGetter(Text::dropShadow)).apply((Applicative)instance, Text::new));
    }

    public record Icon(ResourceLocation atlasLocation, int x, int y, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        public static final Codec<Icon> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("atlasLocation").forGetter(Icon::atlasLocation), (App)Codec.INT.lenientOptionalFieldOf("x", (Object)0).forGetter(Icon::x), (App)Codec.INT.lenientOptionalFieldOf("y", (Object)0).forGetter(Icon::y), (App)Codec.FLOAT.lenientOptionalFieldOf("uOffset", (Object)Float.valueOf(0.0f)).forGetter(Icon::uOffset), (App)Codec.FLOAT.lenientOptionalFieldOf("vOffset", (Object)Float.valueOf(0.0f)).forGetter(Icon::vOffset), (App)Codec.INT.fieldOf("uWidth").forGetter(Icon::uWidth), (App)Codec.INT.fieldOf("vHeight").forGetter(Icon::vHeight), (App)Codec.INT.lenientOptionalFieldOf("textureWidth", (Object)256).forGetter(Icon::textureWidth), (App)Codec.INT.lenientOptionalFieldOf("textureHeight", (Object)256).forGetter(Icon::textureHeight)).apply((Applicative)instance, Icon::new));
    }

    public record MuralData(float x, float y, float z, float roll, float scale, Optional<Icon> icon, Optional<Text> text) {
        public static final Codec<MuralData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.lenientOptionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(MuralData::x), (App)Codec.FLOAT.lenientOptionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(MuralData::y), (App)Codec.FLOAT.lenientOptionalFieldOf("z", (Object)Float.valueOf(0.0f)).forGetter(MuralData::z), (App)Codec.FLOAT.lenientOptionalFieldOf("roll", (Object)Float.valueOf(0.0f)).forGetter(MuralData::roll), (App)Codec.FLOAT.lenientOptionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(MuralData::scale), (App)Icon.CODEC.lenientOptionalFieldOf("icon").forGetter(MuralData::icon), (App)Text.CODEC.lenientOptionalFieldOf("text").forGetter(MuralData::text)).apply((Applicative)instance, MuralData::new));
        public static final Codec<List<MuralData>> LIST_CODEC = CODEC.listOf();

        public static Tag encode(Optional<List<MuralData>> datas, HolderLookup.Provider registries) {
            return datas.flatMap(data -> LIST_CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), data).result()).orElseGet(ListTag::new);
        }

        public static Optional<List<MuralData>> decode(ListTag tag, HolderLookup.Provider registries) {
            return LIST_CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result();
        }
    }
}

