/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import com.mojang.datafixers.util.Function3;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.common.StatueBlock;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.init.block.StatueBlocks;
import org.jetbrains.annotations.Nullable;

public class BehaviourStatueBlock
extends StatueBlock
implements INetworkBlock,
EntityBlock {
    private final Behaviour behaviour;

    public BehaviourStatueBlock(Behaviour behaviour, BlockBehaviour.Properties properties) {
        super(properties);
        this.behaviour = behaviour;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{StateProperties.DRIVE}));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState original = super.getStateForPlacement(context);
        return original == null ? null : this.behaviour.getStateForPlacement(context, original);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = this.behaviour.getShape(state, level, pos, context);
        return shape == null ? super.getShape(state, level, pos, context) : shape;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (state.getBlock() != newState.getBlock()) {
            this.onNodeRemove(state, level, pos, newState);
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.behaviour.onExecute(state, level, pos, color, networkEntity);
        this.execution(state, level, pos, color, true);
    }

    @Override
    public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.behaviour.onUnExecute(state, level, pos, color, networkEntity);
        this.execution(state, level, pos, color, false);
    }

    private void execution(BlockState state, ServerLevel level, BlockPos pos, int color, boolean hasSignal) {
        INetworkEntity entity;
        Network network;
        BlockPos relative = pos.relative(StateProperties.VerticalTwoPart.getConnectedDirection((BlockState)state));
        BlockEntity blockEntity = level.getBlockEntity(relative);
        if (blockEntity instanceof INetworkEntity && (network = (entity = (INetworkEntity)blockEntity).getOrCreateNetworkNode().getNetwork(color)) != null && hasSignal != network.hasSignal()) {
            network.setSignal(hasSignal);
            network.getNodes().stream().map(NetworkNode::getEntity).collect(Collectors.toSet()).forEach(entity1 -> INetworkBlock.internalExecute(level, relative, color, hasSignal, entity1));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.behaviour.newBlockEntity(pos, state);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.behaviour.tick(state, level, pos, random);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ((StateProperties.VerticalTwoPart)state.getValue((Property)StateProperties.VERTICAL_TWO_PART)).isBase() ? LibUtils.getTicker(blockEntityType, StatueBlocks.BLOCK_ENTITY.get(), this.behaviour::entityTick) : null;
    }

    public static class Behaviour {
        @Nullable
        public BEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new BEntity(pos, state);
        }

        public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        }

        public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        }

        public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
            if (((Boolean)state.getValue((Property)StateProperties.DRIVE)).booleanValue()) {
                BlockState state1 = (BlockState)state.setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(false));
                level.setBlockAndUpdate(pos, state1);
                level.setBlockAndUpdate(pos.relative(StateProperties.VerticalTwoPart.getConnectedDirection((BlockState)state)), state1);
            }
        }

        public void entityTick(Level level, BlockPos pos, BlockState blockState, BEntity entity) {
        }

        public BlockState getStateForPlacement(BlockPlaceContext context, BlockState state) {
            return state;
        }

        @Nullable
        public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            return null;
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        }
    }

    public static class BEntity
    extends AbstractMechanicalBlock.BEntity {
        public BEntity(BlockPos pos, BlockState state) {
            super(StatueBlocks.BLOCK_ENTITY.get(), pos, state);
        }

        @Override
        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            ((BehaviourStatueBlock)this.getBlockState().getBlock()).behaviour.saveAdditional(tag, registries);
        }

        @Override
        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            ((BehaviourStatueBlock)this.getBlockState().getBlock()).behaviour.loadAdditional(tag, registries);
        }

        @Override
        public void connectTo(int color, BlockPos relatedPos, INetworkEntity related) {
            if (!relatedPos.equals((Object)this.getBlockPos().relative(StateProperties.VerticalTwoPart.getConnectedDirection((BlockState)this.getBlockState())))) {
                super.connectTo(color, relatedPos, related);
            }
        }
    }

    public static class SummonBehaviour<E extends Entity>
    extends Behaviour {
        private final List<UUID> entities = new ArrayList<UUID>();
        private final boolean randomPos;
        private final boolean noDrops;
        private final int cooldown;
        private final Function3<BlockState, Level, Vec3, E> factory;
        private final Consumer<E> afterSummon;

        public SummonBehaviour(boolean randomPos, boolean noDrops, Function3<BlockState, Level, Vec3, E> factory) {
            this(randomPos, noDrops, 10, factory, entity -> {});
        }

        public SummonBehaviour(boolean randomPos, boolean noDrops, Function3<BlockState, Level, Vec3, E> factory, Consumer<E> afterSummon) {
            this(randomPos, noDrops, 10, factory, afterSummon);
        }

        public SummonBehaviour(boolean randomPos, boolean noDrops, int cooldown, Function3<BlockState, Level, Vec3, E> factory) {
            this(randomPos, noDrops, cooldown, factory, entity -> {});
        }

        public SummonBehaviour(boolean randomPos, boolean noDrops, int cooldown, Function3<BlockState, Level, Vec3, E> factory, Consumer<E> afterSummon) {
            this.randomPos = randomPos;
            this.noDrops = noDrops;
            this.cooldown = cooldown;
            this.factory = factory;
            this.afterSummon = afterSummon;
        }

        @Override
        public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
            if (!((Boolean)state.getValue((Property)StateProperties.DRIVE)).booleanValue() && ((StateProperties.VerticalTwoPart)state.getValue((Property)StateProperties.VERTICAL_TWO_PART)).isBase()) {
                this.entities.removeIf(entity -> {
                    Entity entity1 = level.getEntity(entity);
                    return entity1 == null || entity1.isRemoved();
                });
                if (this.entities.size() >= 3) {
                    return;
                }
                BlockPos relative = this.randomPos ? pos.relative((Direction)Util.getRandom((Object[])LibUtils.HORIZONTAL, (RandomSource)level.random)) : pos;
                Entity entity2 = (Entity)this.factory.apply((Object)state, (Object)level, (Object)relative.getCenter());
                level.addFreshEntity(entity2);
                this.afterSummon.accept(entity2);
                if (this.noDrops) {
                    entity2.addTag("confluence:no_drops");
                }
                this.entities.add(entity2.getUUID());
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StateProperties.DRIVE, (Comparable)Boolean.valueOf(true)));
                level.scheduleTick(pos, state.getBlock(), this.cooldown);
                networkEntity.getSelf().setChanged();
            }
        }

        @Override
        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            ListTag listTag = new ListTag();
            for (UUID entity : this.entities) {
                listTag.add((Object)NbtUtils.createUUID((UUID)entity));
            }
            tag.put("entities", (Tag)listTag);
        }

        @Override
        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            this.entities.clear();
            for (Tag entity : tag.getList("entities", 11)) {
                this.entities.add(NbtUtils.loadUUID((Tag)entity));
            }
        }
    }
}

