/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.mesdag.particlestorm.data.molang.MolangExp;
import org.mesdag.particlestorm.network.EmitterCreationPacketS2C;

public class ConfettiCannonBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
INetworkBlock {
    public static final IntegerProperty PITCH_30 = IntegerProperty.create((String)"pitch_30", (int)0, (int)6);
    public static final MapCodec<ConfettiCannonBlock> CODEC = ConfettiCannonBlock.simpleCodec(ConfettiCannonBlock::new);

    public ConfettiCannonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)PITCH_30, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PITCH_30});
    }

    protected MapCodec<ConfettiCannonBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AbstractMechanicalBlock.BEntity(pos, state);
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        int pitch = (Integer)state.getValue((Property)PITCH_30) * 30;
        int yaw = (((Direction)state.getValue((Property)FACING)).get2DDataValue() & 3) * 90;
        MolangExp expression = new MolangExp(Map.of("variable.pitch", Integer.toString(pitch), "variable.yaw", Integer.toString(yaw)));
        EmitterCreationPacketS2C.sendToAll((ResourceLocation)Confluence.asResource("confetti"), (Vector3f)pos.getCenter().toVector3f(), (MolangExp)expression, null);
    }
}

