/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.functional.network.INetworkBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.armor.BaseVanityArmorItem;
import org.jetbrains.annotations.Nullable;

public class DeathChestBlock
extends BaseChestBlock
implements INetworkBlock {
    public DeathChestBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TRAPPED_CHEST).explosionResistance(ModBlocks.getObsidianBasedExplosionResistance(0.0f)), ChestBlocks.DEATH_CHEST_ENTITY::get, null);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BEntity(pPos, pState);
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState pState) {
        return true;
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)pBlockAccess, (BlockPos)pPos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pSide == Direction.UP ? pBlockState.getSignal(pBlockAccess, pPos, pSide) : 0;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        this.onNodeRemove(pState, pLevel, pPos, pNewState);
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (this.skipInteraction(pPlayer.getMainHandItem())) {
            return InteractionResult.PASS;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHit);
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.execution(state, level, pos, color, true);
    }

    @Override
    public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        this.execution(state, level, pos, color, false);
    }

    private void execution(BlockState pState, ServerLevel pLevel, BlockPos pPos, int pColor, boolean hasSignal) {
        INetworkEntity entity;
        Network network;
        BlockEntity blockEntity;
        if (pColor == -1) {
            return;
        }
        BlockPos relative = pPos.relative(DeathChestBlock.getConnectedDirection((BlockState)pState));
        if (pState.getValue((Property)TYPE) != ChestType.SINGLE && (blockEntity = pLevel.getBlockEntity(relative)) instanceof INetworkEntity && (network = (entity = (INetworkEntity)blockEntity).getOrCreateNetworkNode().getNetwork(pColor)) != null && hasSignal != network.hasSignal()) {
            network.setSignal(hasSignal);
            network.getNodes().stream().map(NetworkNode::getEntity).collect(Collectors.toSet()).forEach(entity1 -> INetworkBlock.internalExecute(pLevel, relative, pColor, hasSignal, entity1));
        }
    }

    public static class BEntity
    extends BaseChestBlock.BEntity
    implements INetworkEntity {
        private NetworkNode networkNode;
        private final Int2ObjectMap<Set<BlockPos>> connectedPoses = new Int2ObjectOpenHashMap();
        private final Int2ObjectMap<Set<BlockPos>> relativePoses = new Int2ObjectOpenHashMap();

        public BEntity(BlockPos pPos, BlockState pBlockState) {
            super(ChestBlocks.DEATH_CHEST_ENTITY.get(), pPos, pBlockState);
        }

        protected void signalOpenCount(Level pLevel, BlockPos pPos, BlockState pState, int pEventId, int pEventParam) {
            super.signalOpenCount(pLevel, pPos, pState, pEventId, pEventParam);
            if (pEventId != pEventParam) {
                Block block = pState.getBlock();
                pLevel.updateNeighborsAt(pPos, block);
                pLevel.updateNeighborsAt(pPos.below(), block);
            }
        }

        public void unpackLootTable(@Nullable Player player) {
            if (this.getLootTable() != null) {
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    if (!((ItemStack)this.getItems().get(i)).isEmpty()) continue;
                    this.getItems().set(i, (Object)((BaseVanityArmorItem)((Object)VanityArmorItems.DEAD_MANS_SWEATER.get())).getDefaultInstance());
                    break;
                }
            }
            super.unpackLootTable(player);
        }

        public void startOpen(Player pPlayer) {
            super.startOpen(pPlayer);
            if (this.openersCounter.getOpenerCount() == 1) {
                ((INetworkBlock)this.getBlockState().getBlock()).execute(this.getBlockState(), (ServerLevel)this.getLevel(), this.getBlockPos(), true);
            }
        }

        public void stopOpen(Player pPlayer) {
            super.stopOpen(pPlayer);
            if (this.openersCounter.getOpenerCount() == 0) {
                ((INetworkBlock)this.getBlockState().getBlock()).execute(this.getBlockState(), (ServerLevel)this.getLevel(), this.getBlockPos(), false);
            }
        }

        public void onLoad() {
            super.onLoad();
            this.onNodeLoad();
        }

        public void onChunkUnloaded() {
            super.onChunkUnloaded();
            this.onNodeUnload();
        }

        public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
            super.loadAdditional(tag, registryLookup);
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
            this.deserializePoses(tag, "relativePoses", this.relativePoses);
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.serializePoses(tag, "connectedPoses", this.connectedPoses);
            this.serializePoses(tag, "relativePoses", this.relativePoses);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            return this.serializePoses(new CompoundTag(), "connectedPoses", this.connectedPoses);
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.deserializePoses(tag, "connectedPoses", this.connectedPoses);
        }

        @Override
        public BlockEntity getSelf() {
            return this;
        }

        @Override
        public void setNetworkNode(NetworkNode node) {
            this.networkNode = node;
        }

        @Override
        @Nullable
        public NetworkNode getNetworkNode() {
            return this.networkNode;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getConnectedPoses() {
            return this.connectedPoses;
        }

        @Override
        public Int2ObjectMap<Set<BlockPos>> getRelativePoses() {
            return this.relativePoses;
        }

        @Override
        public void connectTo(int color, BlockPos relatedPos, INetworkEntity related) {
            if (this.getBlockState().getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE || !relatedPos.equals((Object)this.getBlockPos().relative(ChestBlock.getConnectedDirection((BlockState)this.getBlockState())))) {
                INetworkEntity.super.connectTo(color, relatedPos, related);
            }
        }
    }
}

