/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.init.ModEffects;
import org.jetbrains.annotations.Nullable;

public class LifeCampfireBlock
extends CampfireBlock {
    public LifeCampfireBlock(BlockBehaviour.Properties properties) {
        super(true, 1, properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? LifeCampfireBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityType.CAMPFIRE, CampfireBlockEntity::particleTick) : null;
        }
        return LifeCampfireBlock.createTickerHelper(blockEntityType, (BlockEntityType)BlockEntityType.CAMPFIRE, (serverLevel, pos, blockState, blockEntity) -> {
            if (((Boolean)blockState.getValue((Property)LIT)).booleanValue()) {
                CampfireBlockEntity.cookTick((Level)serverLevel, (BlockPos)pos, (BlockState)blockState, (CampfireBlockEntity)blockEntity);
                if (serverLevel.getGameTime() % 200L == 0L) {
                    Vec3 center = pos.getCenter();
                    for (Player player : serverLevel.players()) {
                        if (!(player.distanceToSqr(center) < 1024.0)) continue;
                        player.addEffect(new MobEffectInstance(ModEffects.COZY_FIRE, 420));
                    }
                }
            } else {
                CampfireBlockEntity.cooldownTick((Level)serverLevel, (BlockPos)pos, (BlockState)blockState, (CampfireBlockEntity)blockEntity);
            }
        });
    }
}

