/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class LockBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public LockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.WEST));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            if (entity.matchTool.isEmpty() || entity.matchTool.get().test(stack)) {
                BlockPos relative;
                if (level.destroyBlock(pos, false, (Entity)player) && level.getBlockState(relative = pos.relative((Direction)state.getValue((Property)BlockStateProperties.FACING))).getDestroySpeed((BlockGetter)level, relative) != -1.0f) {
                    level.destroyBlock(relative, false, (Entity)player);
                    if (entity.consumeTool) {
                        stack.shrink(1);
                        return ItemInteractionResult.CONSUME;
                    }
                    return ItemInteractionResult.CONSUME_PARTIAL;
                }
            } else {
                entity.matchTool.get().items().ifPresent(holders -> {
                    MutableComponent itemsNeed = Component.translatable((String)"message.confluence.lock.need");
                    MutableComponent or = Component.translatable((String)"message.confluence.lock.or");
                    Iterator iterator = holders.iterator();
                    while (iterator.hasNext()) {
                        itemsNeed.append(((Item)((Holder)iterator.next()).value()).getDescription());
                        if (!iterator.hasNext()) continue;
                        itemsNeed.append((Component)or);
                    }
                    player.displayClientMessage((Component)itemsNeed, true);
                });
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public static class BEntity
    extends BlockEntity {
        private Optional<ItemPredicate> matchTool = Optional.empty();
        private boolean consumeTool = false;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.LOCK_BLOCK_ENTITY.get(), pos, blockState);
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.matchTool = ItemPredicate.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), (Object)tag.get("MatchTool")).result();
            this.consumeTool = tag.getBoolean("ConsumeTool");
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            this.matchTool.flatMap(predicate -> ItemPredicate.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)registries), predicate).result()).ifPresent(nbt -> tag.put("MatchTool", nbt));
            tag.putBoolean("ConsumeTool", this.consumeTool);
        }
    }
}

