/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.jetbrains.annotations.Nullable;

public class SignalAdapterBlock
extends AbstractMechanicalBlock {
    public SignalAdapterBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false))).setValue((Property)StateProperties.REVERSE, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(pContext.getLevel().hasNeighborSignal(pContext.getClickedPos())));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{StateProperties.SIGNAL, StateProperties.REVERSE});
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!pLevel.isClientSide && ((Boolean)pState.getValue((Property)StateProperties.REVERSE)).booleanValue()) {
            this.execute(pState, (ServerLevel)pLevel, pPos, pLevel.hasNeighborSignal(pPos));
        }
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (this.skipInteraction(pPlayer.getMainHandItem())) {
            return InteractionResult.PASS;
        }
        if (!pLevel.isClientSide && pPlayer.isCrouching()) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)pState.cycle((Property)StateProperties.REVERSE));
        }
        return InteractionResult.SUCCESS;
    }

    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return (Boolean)pState.getValue((Property)StateProperties.REVERSE) == false && (Boolean)pState.getValue((Property)StateProperties.SIGNAL) != false ? 15 : 0;
    }

    public boolean isSignalSource(BlockState pState) {
        return (Boolean)pState.getValue((Property)StateProperties.REVERSE) == false && (Boolean)pState.getValue((Property)StateProperties.SIGNAL) != false;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        if (!((Boolean)state.getValue((Property)StateProperties.SIGNAL)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Override
    public void onUnExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
        if (((Boolean)state.getValue((Property)StateProperties.SIGNAL)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false)));
        }
    }
}

