/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.AbstractMechanicalBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;

public class SwitchBlock
extends AbstractMechanicalBlock {
    protected static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    private static final VoxelShape UP_SHAPE = SwitchBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape DOWN_SHAPE = SwitchBlock.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SOUTH_SHAPE = SwitchBlock.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
    private static final VoxelShape NORTH_SHAPE = SwitchBlock.box((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = SwitchBlock.box((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = SwitchBlock.box((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);

    public SwitchBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LEVER));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)StateProperties.SIGNAL, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((AttachFace)pState.getValue(FACE)) {
            case AttachFace.FLOOR -> UP_SHAPE;
            case AttachFace.WALL -> {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case EAST: {
                        yield EAST_SHAPE;
                    }
                    case WEST: {
                        yield WEST_SHAPE;
                    }
                    case SOUTH: {
                        yield SOUTH_SHAPE;
                    }
                }
                yield NORTH_SHAPE;
            }
            default -> DOWN_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{StateProperties.SIGNAL, FACING, FACE});
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return SwitchBlock.canAttach(pLevel, pPos, SwitchBlock.getConnectedDirection(pState).getOpposite());
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.relative(pDirection);
        return pReader.getBlockState(blockpos).isFaceSturdy((BlockGetter)pReader, blockpos, pDirection.getOpposite());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        for (Direction direction : pContext.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return SwitchBlock.getConnectedDirection(pState).getOpposite() == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (this.skipInteraction(pPlayer.getMainHandItem())) {
            return InteractionResult.PASS;
        }
        if (!pLevel.isClientSide) {
            pState = (BlockState)pState.cycle((Property)StateProperties.SIGNAL);
            pLevel.setBlockAndUpdate(pPos, pState);
            boolean signal = (Boolean)pState.getValue((Property)StateProperties.SIGNAL);
            pLevel.playSound(null, pPos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, signal ? 0.6f : 0.5f);
            this.execute(pState, (ServerLevel)pLevel, pPos, signal);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onExecute(BlockState state, ServerLevel level, BlockPos pos, int color, INetworkEntity networkEntity) {
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        return switch ((AttachFace)pState.getValue(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)pState.getValue((Property)FACING);
        };
    }
}

