/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.recipe.ItemStackHandlerRecipeInput;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.block.AltarBlockModel;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.item.HammerItems;
import org.confluence.mod.common.recipe.AltarRecipe;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terraentity.init.entity.TEMonsterEntities;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AltarBlock
extends BaseEntityBlock {
    public static final MapCodec<AltarBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AltarBlock.propertiesCodec(), (App)Variant.CODEC.fieldOf("variant").orElse((Object)Variant.DEMON).forGetter(block -> block.variant)).apply((Applicative)instance, AltarBlock::new));
    public static final VoxelShape SHAPE = Shapes.box((double)-0.125, (double)0.0, (double)-0.125, (double)1.125, (double)0.8, (double)1.125);
    private static final Component TIPS;
    private final Variant variant;

    public AltarBlock(BlockBehaviour.Properties properties, Variant variant) {
        super(properties);
        this.variant = variant;
    }

    protected MapCodec<AltarBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return player.getMainHandItem().is(ModTags.Items.TOOLS_HAMMER) ? super.getDestroyProgress(state, player, level, pos) : 0.0f;
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (IMinecraftServer.isHardmode(serverPlayer.server)) {
                ServerLevel serverLevel = serverPlayer.serverLevel();
                ConfluenceData data = ConfluenceData.get(serverLevel);
                if (data.increaseRevealStep(serverLevel)) {
                    serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)("event.confluence.reveal_step" + data.getRevealStep())).withColor(GlobalColors.MESSAGE.get()), false);
                }
                if (tool.is(HammerItems.PWNHAMMER)) {
                    AchievementUtils.awardAchievement(serverPlayer, "begone_evil");
                }
                RandomSource random = player.getRandom();
                int wraithAmount = random.nextInt(2) + 1;
                for (int i = 0; i < wraithAmount; ++i) {
                    ((EntityType)TEMonsterEntities.WRAITH.get()).spawn(serverLevel, pos.offset(Mth.randomBetweenInclusive((RandomSource)random, (int)-15, (int)15), Mth.randomBetweenInclusive((RandomSource)random, (int)-15, (int)15), Mth.randomBetweenInclusive((RandomSource)random, (int)-15, (int)15)), MobSpawnType.MOB_SUMMONED);
                }
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)entity.itemHandler.getItems());
            level.removeBlockEntity(pos);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            if (player.isCrouching()) {
                player.addItem(entity.takeItem(-1));
            } else {
                player.setItemInHand(hand, entity.addItem(player.getItemInHand(hand)));
                if (((Boolean)CommonConfigs.ALTAR_TIPS.get()).booleanValue()) {
                    player.displayClientMessage(TIPS, true);
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static void onLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (state.getBlock() instanceof AltarBlock && (blockEntity = level.getBlockEntity(pos)) instanceof BEntity) {
                BEntity entity = (BEntity)blockEntity;
                RecipeManager recipeManager = serverLevel.getServer().getRecipeManager();
                if (player.isCrouching()) {
                    List recipes;
                    boolean crafted = false;
                    while (!(recipes = recipeManager.getRecipesFor(ModRecipes.ALTAR_TYPE.get(), (RecipeInput)entity.itemHandler, level)).isEmpty()) {
                        crafted = true;
                        AltarRecipe recipe = (AltarRecipe)((RecipeHolder)recipes.getFirst()).value();
                        ItemStack result = recipe.assembleAndExtract((RecipeInput)entity.itemHandler, (HolderLookup.Provider)level.registryAccess());
                        LibUtils.createItemEntity((ItemStack)result, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.75), (double)((double)pos.getZ() + 0.5), (Level)level, (int)0);
                    }
                    if (crafted) {
                        entity.playAnimation(serverLevel, pos);
                    }
                } else {
                    List recipes = recipeManager.getRecipesFor(ModRecipes.ALTAR_TYPE.get(), (RecipeInput)entity.itemHandler, level);
                    if (recipes.isEmpty()) {
                        return;
                    }
                    AltarRecipe recipe = (AltarRecipe)((RecipeHolder)recipes.getFirst()).value();
                    ItemStack result = recipe.assembleAndExtract((RecipeInput)entity.itemHandler, (HolderLookup.Provider)level.registryAccess());
                    LibUtils.createItemEntity((ItemStack)result, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.75), (double)((double)pos.getZ() + 0.5), (Level)level, (int)0);
                    entity.playAnimation(serverLevel, pos);
                }
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state).setVariant(this.variant);
    }

    public static boolean hurtPlayerIfBrokenNotAllowed(Player player, BlockState blockState) {
        if (!player.hasInfiniteMaterials() && blockState.getBlock() instanceof AltarBlock && !player.getMainHandItem().is(ModTags.Items.ABLE_TO_DESTROY_ALTAR)) {
            player.hurt(player.damageSources().fellOutOfWorld(), player.getMaxHealth() / 2.0f);
            return true;
        }
        return false;
    }

    static {
        ResourceLocation fontId = Confluence.asResource("button");
        UnaryOperator button = style -> style.withFont(fontId);
        TIPS = Component.empty().append((Component)Component.literal((String)"2").withStyle(button)).append((Component)Component.translatable((String)"message.confluence.altar_tips.0")).append((Component)Component.literal((String)"23").withStyle(button)).append((Component)Component.translatable((String)"message.confluence.altar_tips.1")).append((Component)Component.literal((String)"1").withStyle(button)).append((Component)Component.translatable((String)"message.confluence.altar_tips.2")).append((Component)Component.literal((String)"13").withStyle(button)).append((Component)Component.translatable((String)"message.confluence.altar_tips.3"));
    }

    public static enum Variant implements StringRepresentable
    {
        DEMON(0, "demon"),
        CRIMSON(1, "crimson");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public static class BEntity
    extends BaseContainerBlockEntity
    implements GeoBlockEntity {
        public static final int CONTAINER_SIZE = 6;
        private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        private final ItemStackHandlerRecipeInput itemHandler = new ItemStackHandlerRecipeInput((BlockEntity)this, 6);
        private Variant variant;

        public BEntity(BlockPos pos, BlockState blockState) {
            super(FunctionalBlocks.ALTAR_BLOCK_ENTITY.get(), pos, blockState);
            SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        }

        public ItemStack addItem(ItemStack toAdd) {
            int firstEmptySlot = -1;
            for (int i = 0; i < 5; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (firstEmptySlot == -1 && stack.isEmpty()) {
                    firstEmptySlot = i;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toAdd)) continue;
                ItemStack result = this.itemHandler.insertItem(i, toAdd, false);
                this.setChanged();
                return result;
            }
            if (firstEmptySlot != -1) {
                this.itemHandler.setStackInSlot(firstEmptySlot, toAdd);
                this.setChanged();
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }

        public ItemStack takeItem(int slot) {
            if (slot == -1) {
                for (int i = 0; i < 5; ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    stack = this.itemHandler.extractItem(i, stack.getMaxStackSize(), false);
                    this.setChanged();
                    return stack;
                }
                return ItemStack.EMPTY;
            }
            ItemStack stack = this.itemHandler.getStackInSlot(slot).copy();
            this.itemHandler.setStackInSlot(slot, ItemStack.EMPTY);
            this.setChanged();
            return stack;
        }

        BEntity setVariant(Variant variant) {
            this.variant = variant;
            this.markUpdated();
            return this;
        }

        public Variant getVariant() {
            return this.variant;
        }

        public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
            super.loadAdditional(nbt, registries);
            this.variant = Variant.byId(nbt.getInt("variant"));
            this.itemHandler.setItems(NonNullList.withSize((int)6, (Object)ItemStack.EMPTY));
            ContainerHelper.loadAllItems((CompoundTag)nbt, (NonNullList)this.itemHandler.getItems(), (HolderLookup.Provider)registries);
        }

        protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
            super.saveAdditional(nbt, registries);
            nbt.putInt("variant", this.variant.id);
            ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.itemHandler.getItems(), (HolderLookup.Provider)registries);
        }

        protected Component getDefaultName() {
            return Component.empty();
        }

        protected NonNullList<ItemStack> getItems() {
            return this.itemHandler.getItems();
        }

        protected void setItems(NonNullList<ItemStack> items) {
            this.itemHandler.setItems(items);
        }

        public boolean canOpen(Player player) {
            return false;
        }

        protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
            throw new UnsupportedOperationException();
        }

        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        }

        public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("variant", this.variant.id);
            ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)this.itemHandler.getItems(), (HolderLookup.Provider)registries);
            return nbt;
        }

        public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            this.variant = Variant.byId(tag.getInt("variant"));
            this.itemHandler.setItems(NonNullList.withSize((int)6, (Object)ItemStack.EMPTY));
            ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.itemHandler.getItems(), (HolderLookup.Provider)lookupProvider);
        }

        public void markUpdated() {
            this.setChanged();
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
            controllers.add(new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenLoop("default"))).triggerableAnim("crafting", RawAnimation.begin().thenPlay("crafting")));
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.CACHE;
        }

        private void playAnimation(ServerLevel level, BlockPos pos) {
            this.triggerAnim("controller", "crafting");
            switch (this.variant.ordinal()) {
                case 0: {
                    level.sendParticles((ParticleOptions)ParticleTypes.SOUL, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.75f), (double)((float)pos.getZ() + 0.5f), 20, 0.0, 0.0, 0.0, (double)0.02f);
                    break;
                }
                case 1: {
                    level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.REDSTONE_BLOCK.defaultBlockState()), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.75f), (double)((float)pos.getZ() + 0.5f), 500, 0.0, 0.0625, 0.0, 0.25);
                }
            }
        }

        public int getContainerSize() {
            return this.itemHandler.size();
        }
    }

    public static class BItem
    extends BlockItem
    implements GeoItem {
        private final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

        public BItem(AltarBlock block) {
            super((Block)block, new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.PURPLE));
        }

        public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
            consumer.accept(new GeoRenderProvider(this){
                private GeoItemRenderer<BItem> renderer;

                public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                    if (this.renderer == null) {
                        this.renderer = new GeoItemRenderer((GeoModel)new GeoModel<BItem>(this){

                            public ResourceLocation getModelResource(BItem animatable) {
                                return AltarBlockModel.MODELS[animatable.getVariant().getId()];
                            }

                            public ResourceLocation getTextureResource(BItem animatable) {
                                return AltarBlockModel.TEXTURES[animatable.getVariant().getId()];
                            }

                            public ResourceLocation getAnimationResource(BItem animatable) {
                                return AltarBlockModel.ANIMATIONS[animatable.getVariant().getId()];
                            }
                        });
                    }
                    return this.renderer;
                }
            });
        }

        public Variant getVariant() {
            return ((AltarBlock)this.getBlock()).variant;
        }

        public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        }

        public AnimatableInstanceCache getAnimatableInstanceCache() {
            return this.CACHE;
        }
    }
}

