/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.crafting.CookingPotBlock;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.menu.CookingPotMenu;
import org.confluence.mod.common.recipe.CookingPotRecipe;
import org.jetbrains.annotations.Nullable;

public class BaseCauldronBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<BaseCauldronBlock> CODEC = BaseCauldronBlock.simpleCodec(BaseCauldronBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BaseCauldronBlock.box((double)1.0, (double)0.016, (double)1.0, (double)15.0, (double)8.016, (double)15.0), (VoxelShape[])new VoxelShape[]{BaseCauldronBlock.box((double)1.0, (double)10.016, (double)1.0, (double)15.0, (double)12.016, (double)15.0), BaseCauldronBlock.box((double)2.0, (double)8.016, (double)2.0, (double)14.0, (double)10.016, (double)14.0)});

    public BaseCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BaseCauldronBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            player.openMenu((MenuProvider)entity);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                if (!level.isClientSide) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
                }
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.LIT, FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : LibUtils.getTicker(blockEntityType, FunctionalBlocks.CAULDRON_ENTITY.get(), BEntity::serverTick);
    }

    public static class BEntity
    extends BaseContainerBlockEntity {
        protected NonNullList<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        int cookingProgress;
        int cookingTotalTime;
        int heatSourceItem = CookingPotBlock.BItem.getId((Item)Items.AIR);
        ItemStack[] itemStacks = new ItemStack[4];
        protected final ContainerData dataAccess = new ContainerData(){

            public int get(int data) {
                return switch (data) {
                    case 0 -> cookingProgress;
                    case 1 -> cookingTotalTime;
                    case 2 -> heatSourceItem;
                    default -> 0;
                };
            }

            public void set(int data, int value) {
                switch (data) {
                    case 0: {
                        cookingProgress = value;
                        break;
                    }
                    case 1: {
                        cookingTotalTime = value;
                        break;
                    }
                    case 2: {
                        heatSourceItem = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
        private final RecipeManager.CachedCheck<CookingPotRecipe.Input, CookingPotRecipe> cachedCheck = RecipeManager.createCheck(ModRecipes.COOKING_POT_TYPE.get());

        public BEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
            super(blockEntityType, pos, blockState);
        }

        public BEntity(BlockPos pos, BlockState blockState) {
            this(FunctionalBlocks.CAULDRON_ENTITY.get(), pos, blockState);
        }

        public static void serverTick(Level level, BlockPos pos, BlockState state, BEntity blockEntity) {
            CookingPotRecipe.Input input;
            Optional recipeFor;
            ItemStack[] itemStacks;
            boolean hasItem;
            BlockInWorld heatSource = new BlockInWorld((LevelReader)level, pos.below(), true);
            if (level.getGameTime() % 20L == 1L) {
                blockEntity.heatSourceItem = Item.getId((Item)heatSource.getState().getBlock().asItem());
            }
            boolean bl = hasItem = !(itemStacks = blockEntity.getItemStacks())[0].isEmpty() || !itemStacks[1].isEmpty() || !itemStacks[2].isEmpty() || !itemStacks[3].isEmpty();
            if (hasItem && (recipeFor = blockEntity.cachedCheck.getRecipeFor((RecipeInput)(input = new CookingPotRecipe.Input(itemStacks, blockEntity.getItem(4), heatSource)), level)).isPresent()) {
                CookingPotRecipe recipe = (CookingPotRecipe)((RecipeHolder)recipeFor.get()).value();
                if (BEntity.canResultInsert(blockEntity.items, blockEntity.getMaxStackSize(), recipe.getResultItem(null))) {
                    blockEntity.cookingTotalTime = recipe.getCookingTime();
                    if (++blockEntity.cookingProgress >= blockEntity.cookingTotalTime) {
                        ((ItemStack)blockEntity.items.get(4)).shrink(1);
                        ItemStack neoResult = recipe.assembleAndExtract(input, (HolderLookup.Provider)level.registryAccess());
                        ItemStack oldResult = (ItemStack)blockEntity.items.get(5);
                        if (oldResult.isEmpty()) {
                            blockEntity.items.set(5, (Object)neoResult.copy());
                        } else if (ItemStack.isSameItemSameComponents((ItemStack)oldResult, (ItemStack)neoResult)) {
                            oldResult.grow(neoResult.getCount());
                        }
                    } else {
                        return;
                    }
                }
            }
            blockEntity.cookingProgress = 0;
        }

        private ItemStack[] getItemStacks() {
            this.itemStacks[0] = (ItemStack)this.items.get(0);
            this.itemStacks[1] = (ItemStack)this.items.get(1);
            this.itemStacks[2] = (ItemStack)this.items.get(2);
            this.itemStacks[3] = (ItemStack)this.items.get(3);
            return this.itemStacks;
        }

        private static boolean canResultInsert(NonNullList<ItemStack> inventory, int maxStackSize, ItemStack neoResult) {
            if (neoResult.isEmpty()) {
                return false;
            }
            ItemStack oldResult = (ItemStack)inventory.get(5);
            if (oldResult.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)oldResult, (ItemStack)neoResult)) {
                return false;
            }
            return oldResult.getCount() + neoResult.getCount() <= maxStackSize && oldResult.getCount() + neoResult.getCount() <= oldResult.getMaxStackSize() || oldResult.getCount() + neoResult.getCount() <= neoResult.getMaxStackSize();
        }

        protected Component getDefaultName() {
            return Component.translatable((String)"container.confluence.cauldron");
        }

        protected NonNullList<ItemStack> getItems() {
            return this.items;
        }

        protected void setItems(NonNullList<ItemStack> items) {
            this.items = items;
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
            this.cookingProgress = tag.getInt("CookTime");
            this.cookingTotalTime = tag.getInt("CookTimeTotal");
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            tag.putInt("CookTime", this.cookingProgress);
            tag.putInt("CookTimeTotal", this.cookingTotalTime);
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }

        protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
            return new CookingPotMenu(containerId, inventory, (Container)this, this.dataAccess);
        }

        public int getContainerSize() {
            return this.items.size();
        }
    }
}

