/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.block.HorizontalDirectionalWithHorizontalTwoPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.lib.common.recipe.ArrayRecipeInput;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.recipe.EnhancedForgeRecipe;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedForgeBlock
extends HorizontalDirectionalWithHorizontalTwoPartBlock
implements EntityBlock {
    public EnhancedForgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BEntity) {
            BEntity entity = (BEntity)blockEntity;
            player.openMenu((MenuProvider)entity);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moveByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BEntity) {
                BEntity entity = (BEntity)blockEntity;
                if (((StateProperties.HorizontalTwoPart)state.getValue((Property)PART)).isBase()) {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        Containers.dropContents((Level)level, (BlockPos)pos, (Container)entity);
                        entity.getRecipesToAwardAndPopExperience(serverLevel, Vec3.atCenterOf((Vec3i)pos));
                    }
                    level.updateNeighbourForOutputSignal(pos, (Block)this);
                }
            }
            super.onRemove(state, level, pos, newState, moveByPiston);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{BlockStateProperties.LIT}));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide || ((StateProperties.HorizontalTwoPart)state.getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isRight() ? null : LibUtils.getTicker(blockEntityType, this.getBlockEntityType(), this::serverTick);
    }

    protected <T extends EnhancedForgeRecipe> void serverTick(Level level, BlockPos pos, BlockState state, BEntity<T> entity) {
        boolean forgeMatched;
        ItemStack[] itemStacks;
        boolean isLit = entity.isLit();
        boolean[] data = new boolean[2];
        if (isLit) {
            --entity.litTime;
            entity.resetCookTime();
        }
        boolean hasItem = !(itemStacks = entity.getItemStacks())[0].isEmpty() || !itemStacks[1].isEmpty() || !itemStacks[2].isEmpty() || !itemStacks[3].isEmpty();
        boolean bl = forgeMatched = hasItem && this.isForgeMatched(level, entity, itemStacks, data);
        if (hasItem && !forgeMatched) {
            SingleRecipeInput recipeInput;
            RecipeHolder recipeholder;
            ItemStack lastInput = itemStacks[entity.lastCheckSlot];
            if (!lastInput.isEmpty() && (recipeholder = (RecipeHolder)entity.blasting.getRecipeFor((RecipeInput)(recipeInput = new SingleRecipeInput(lastInput)), level).orElse(null)) != null && ((BlastingRecipe)recipeholder.value()).matches(recipeInput, level)) {
                entity.doBlasting((RecipeHolder<BlastingRecipe>)recipeholder, lastInput, data);
            } else {
                for (int i = 0; i < itemStacks.length; ++i) {
                    ItemStack input = itemStacks[i];
                    if (input.isEmpty() || (recipeholder = (RecipeHolder)entity.blasting.getRecipeFor((RecipeInput)new SingleRecipeInput(input), level).orElse(null)) == null) continue;
                    entity.doBlasting((RecipeHolder<BlastingRecipe>)recipeholder, input, data);
                    entity.lastCheckSlot = i;
                    break;
                }
            }
        }
        if (!data[1] && !forgeMatched) {
            entity.cookingProgress = 0;
        }
        if (isLit != entity.isLit()) {
            data[0] = true;
            state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(entity.isLit()));
            level.setBlockAndUpdate(pos, state);
        }
        if (data[0]) {
            BlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected <T extends EnhancedForgeRecipe> boolean isForgeMatched(Level level, BEntity<T> entity, ItemStack[] itemStacks, boolean[] data) {
        RecipeHolder recipeholder = entity.forge.getRecipeFor((RecipeInput)new ArrayRecipeInput(itemStacks), level).orElse(null);
        if (recipeholder != null) {
            if (!entity.isLit() && entity.canForgeBurn(recipeholder)) {
                data[0] = entity.doUpdateStatus();
            }
            if (entity.canForgeBurn(recipeholder)) {
                if (entity.doUpdateProgress(recipeholder, entity::burnForge)) {
                    data[0] = true;
                }
            }
            return true;
        }
        return false;
    }

    protected abstract BlockEntityType<? extends BEntity<?>> getBlockEntityType();

    public static abstract class BEntity<T extends EnhancedForgeRecipe>
    extends BaseContainerBlockEntity
    implements WorldlyContainer,
    RecipeCraftingHolder {
        public static final int INPUT_SLOT_1 = 0;
        public static final int INPUT_SLOT_2 = 1;
        public static final int INPUT_SLOT_3 = 2;
        public static final int INPUT_SLOT_4 = 3;
        public static final int FUEL_SLOT = 4;
        public static final int RESULT_SLOT = 5;
        public static final int DATA_COUNT = 5;
        public static final int SLOT_COUNT = 6;
        protected static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3};
        protected static final int[] SLOTS_FOR_DOWN = new int[]{5, 4};
        protected static final int[] SLOTS_FOR_SIDES = new int[]{4};
        protected NonNullList<ItemStack> items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
        protected int litTime;
        protected int litDuration;
        protected int cookingProgress;
        protected int cookingTotalTime;
        protected int useFuel;
        protected final ContainerData dataAccess = new ContainerData(){

            public int get(int data) {
                return switch (data) {
                    case 0 -> {
                        if (litDuration > Short.MAX_VALUE) {
                            yield Mth.floor((double)((double)litTime / (double)litDuration * 32767.0));
                        }
                        yield litTime;
                    }
                    case 1 -> Math.min(litDuration, Short.MAX_VALUE);
                    case 2 -> cookingProgress;
                    case 3 -> cookingTotalTime;
                    case 4 -> useFuel;
                    default -> 0;
                };
            }

            public void set(int data, int value) {
                switch (data) {
                    case 0: {
                        litTime = value;
                        break;
                    }
                    case 1: {
                        litDuration = value;
                        break;
                    }
                    case 2: {
                        cookingProgress = value;
                        break;
                    }
                    case 3: {
                        cookingTotalTime = value;
                        break;
                    }
                    case 4: {
                        useFuel = value;
                    }
                }
            }

            public int getCount() {
                return 5;
            }
        };
        protected final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
        protected final RecipeManager.CachedCheck<RecipeInput, T> forge;
        protected final RecipeManager.CachedCheck<SingleRecipeInput, BlastingRecipe> blasting;
        protected final ItemStack[] itemStacks = new ItemStack[4];
        protected int lastCheckSlot = 0;

        public BEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
            super(type, pos, blockState);
            this.forge = BEntity.createCachedCheck(this.getRecipeType());
            this.blasting = RecipeManager.createCheck((RecipeType)RecipeType.BLASTING);
        }

        protected abstract RecipeType<T> getRecipeType();

        protected static <R extends EnhancedForgeRecipe> RecipeManager.CachedCheck<RecipeInput, R> createCachedCheck(final RecipeType<R> recipeType) {
            return new RecipeManager.CachedCheck<RecipeInput, R>(){
                @Nullable
                private RecipeHolder<R> lastRecipe;
                private int lastIngredientCount = 0;

                public Optional<RecipeHolder<R>> getRecipeFor(RecipeInput recipeInput, Level level) {
                    Optional recipe;
                    int count = 0;
                    for (int i = 0; i < recipeInput.size(); ++i) {
                        if (recipeInput.getItem(i).isEmpty()) continue;
                        ++count;
                    }
                    if (count == 0) {
                        return Optional.empty();
                    }
                    if (this.lastRecipe != null && ((EnhancedForgeRecipe)this.lastRecipe.value()).matches(recipeInput, level)) {
                        if (count == this.lastIngredientCount) {
                            return Optional.of(this.lastRecipe);
                        }
                        this.lastIngredientCount = count;
                    }
                    if ((recipe = level.getRecipeManager().byType(recipeType).stream().filter(holder -> ((EnhancedForgeRecipe)holder.value()).matches(recipeInput, level)).max(Comparator.comparingInt(holder -> ((EnhancedForgeRecipe)holder.value()).ingredients.size()))).isPresent()) {
                        this.lastRecipe = recipe.get();
                        return recipe;
                    }
                    return Optional.empty();
                }
            };
        }

        protected void doBlasting(RecipeHolder<BlastingRecipe> recipeholder, ItemStack lastInput, boolean[] data) {
            if (!this.isLit() && this.canBlastingBurn(recipeholder, lastInput)) {
                data[0] = this.doUpdateStatus();
            }
            if (this.canBlastingBurn(recipeholder, lastInput) && this.doUpdateProgress(recipeholder, recipeHolder -> this.burnBlasting((RecipeHolder<BlastingRecipe>)recipeHolder, lastInput))) {
                data[0] = true;
            }
            data[1] = true;
        }

        protected <R extends Recipe<?>> boolean doUpdateProgress(RecipeHolder<R> recipeholder, Predicate<RecipeHolder<R>> predicate) {
            if (++this.cookingProgress >= this.cookingTotalTime) {
                this.cookingProgress = 0;
                if (!this.isLit()) {
                    this.cookingTotalTime = this.getTotalCookTime();
                }
                if (predicate.test(recipeholder)) {
                    this.setRecipeUsed(recipeholder);
                }
                return true;
            }
            return false;
        }

        protected boolean doUpdateStatus() {
            ItemStack fuel = this.getItem(4);
            this.litDuration = this.litTime = this.getBurnDuration(fuel);
            if (fuel.hasCraftingRemainingItem()) {
                this.items.set(4, (Object)fuel.getCraftingRemainingItem());
            } else if (fuel.isEmpty()) {
                this.useFuel = 0;
            } else {
                fuel.shrink(1);
                if (fuel.isEmpty()) {
                    this.items.set(4, (Object)fuel.getCraftingRemainingItem());
                }
                this.useFuel = 1;
            }
            return true;
        }

        public void setItem(int index, ItemStack stack) {
            ItemStack itemstack = this.getItem(index);
            boolean flag = stack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack);
            this.getItems().set(index, (Object)stack);
            stack.limitSize(this.getMaxStackSize(stack));
            if (index < 4 && flag) {
                this.resetCookTime();
                this.setChanged();
            } else if (index == 4) {
                this.useFuel = stack.isEmpty() ? 0 : 1;
                this.resetCookTime();
                this.setChanged();
            }
        }

        protected void resetCookTime() {
            if (!this.isLit()) {
                this.cookingTotalTime = this.getTotalCookTime();
                if (((ItemStack)this.items.get(4)).isEmpty()) {
                    this.cookingProgress = 0;
                }
            }
        }

        protected boolean canBlastingBurn(RecipeHolder<BlastingRecipe> recipe, ItemStack input) {
            if (!input.isEmpty()) {
                ItemStack neoResult = ((BlastingRecipe)recipe.value()).assemble(new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
                return this.canResultInsert(neoResult);
            }
            return false;
        }

        protected boolean canResultInsert(ItemStack neoResult) {
            if (neoResult.isEmpty()) {
                return false;
            }
            ItemStack oldResult = (ItemStack)this.items.get(5);
            if (oldResult.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)oldResult, (ItemStack)neoResult)) {
                return false;
            }
            return oldResult.getCount() + neoResult.getCount() <= 9999 && oldResult.getCount() + neoResult.getCount() <= oldResult.getMaxStackSize() || oldResult.getCount() + neoResult.getCount() <= neoResult.getMaxStackSize();
        }

        protected boolean burnBlasting(RecipeHolder<BlastingRecipe> recipe, ItemStack input) {
            if (this.canBlastingBurn(recipe, input)) {
                ItemStack neoResult = ((BlastingRecipe)recipe.value()).assemble(new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
                ItemStack oldResult = (ItemStack)this.items.get(5);
                if (oldResult.isEmpty()) {
                    this.items.set(5, (Object)neoResult.copy());
                } else if (ItemStack.isSameItemSameComponents((ItemStack)oldResult, (ItemStack)neoResult)) {
                    oldResult.grow(neoResult.getCount());
                }
                if (input.is(Blocks.WET_SPONGE.asItem()) && ((ItemStack)this.items.get(4)).is(Items.BUCKET)) {
                    this.items.set(4, (Object)Items.WATER_BUCKET.getDefaultInstance());
                }
                input.shrink(1);
                return true;
            }
            return false;
        }

        protected boolean canForgeBurn(RecipeHolder<T> recipe) {
            if ((!((EnhancedForgeRecipe)recipe.value()).isRequiresFuel() || this.useFuel() || this.isLit() || !this.getItem(4).isEmpty()) && Arrays.stream(this.itemStacks).anyMatch(itemStack -> !itemStack.isEmpty())) {
                ItemStack neoResult = ((EnhancedForgeRecipe)recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
                return this.canResultInsert(neoResult);
            }
            return false;
        }

        protected boolean burnForge(RecipeHolder<T> recipe) {
            if (this.canForgeBurn(recipe)) {
                if (((ItemStack)this.items.get(4)).is(Items.BUCKET)) {
                    for (ItemStack input : this.itemStacks) {
                        if (!input.is(Items.WET_SPONGE)) continue;
                        this.items.set(4, (Object)Items.WATER_BUCKET.getDefaultInstance());
                    }
                }
                ItemStack neoResult = ((EnhancedForgeRecipe)recipe.value()).assembleAndExtract((RecipeInput)new ArrayRecipeInput(this.itemStacks), (HolderLookup.Provider)this.level.registryAccess());
                ItemStack oldResult = (ItemStack)this.items.get(5);
                if (oldResult.isEmpty()) {
                    this.items.set(5, (Object)neoResult.copy());
                } else if (ItemStack.isSameItemSameComponents((ItemStack)oldResult, (ItemStack)neoResult)) {
                    oldResult.grow(neoResult.getCount());
                }
                return true;
            }
            return false;
        }

        protected int getBurnDuration(ItemStack fuel) {
            if (fuel.isEmpty()) {
                return 0;
            }
            return fuel.getBurnTime(this.getRecipeType()) / 2;
        }

        protected boolean useFuel() {
            return this.useFuel == 1;
        }

        protected boolean isLit() {
            return this.litTime > 0;
        }

        protected ItemStack[] getItemStacks() {
            this.itemStacks[0] = (ItemStack)this.items.get(0);
            this.itemStacks[1] = (ItemStack)this.items.get(1);
            this.itemStacks[2] = (ItemStack)this.items.get(2);
            this.itemStacks[3] = (ItemStack)this.items.get(3);
            return this.itemStacks;
        }

        protected int getTotalCookTime() {
            int time = this.forge.getRecipeFor((RecipeInput)new ArrayRecipeInput(this.getItemStacks()), this.level).map(holder -> ((EnhancedForgeRecipe)holder.value()).getCookingTime()).orElse(100);
            return ((ItemStack)this.items.get(4)).isEmpty() ? time * 8 : time;
        }

        public int[] getSlotsForFace(Direction side) {
            if (side == Direction.DOWN) {
                return SLOTS_FOR_DOWN;
            }
            return side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
        }

        public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
            return this.canPlaceItem(index, itemStack);
        }

        public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
            return direction != Direction.DOWN || index != 4 || stack.is(Items.WATER_BUCKET) || stack.is(Items.BUCKET);
        }

        public int getContainerSize() {
            return this.items.size();
        }

        protected NonNullList<ItemStack> getItems() {
            if (((StateProperties.HorizontalTwoPart)this.getBlockState().getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isRight()) {
                NonNullList<ItemStack> nonNullList;
                BlockEntity blockEntity;
                if (this.level != null && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(StateProperties.HorizontalTwoPart.getConnectedDirection((BlockState)this.getBlockState())))) instanceof BEntity) {
                    BEntity entity = (BEntity)blockEntity;
                    nonNullList = entity.items;
                } else {
                    nonNullList = this.items;
                }
                return nonNullList;
            }
            return this.items;
        }

        protected void setItems(NonNullList<ItemStack> items) {
            BlockEntity blockEntity;
            if (((StateProperties.HorizontalTwoPart)this.getBlockState().getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isRight() && this.level != null && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(StateProperties.HorizontalTwoPart.getConnectedDirection((BlockState)this.getBlockState())))) instanceof BEntity) {
                BEntity entity = (BEntity)blockEntity;
                entity.items = items;
                return;
            }
            this.items = items;
        }

        protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
            BlockEntity blockEntity;
            if (((StateProperties.HorizontalTwoPart)this.getBlockState().getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isBase()) {
                return this.newMenu(containerId, inventory, (Container)this, this.dataAccess);
            }
            if (this.level != null && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(StateProperties.HorizontalTwoPart.getConnectedDirection((BlockState)this.getBlockState())))) instanceof BEntity) {
                BEntity entity = (BEntity)blockEntity;
                return this.newMenu(containerId, inventory, (Container)entity, entity.dataAccess);
            }
            throw new UnsupportedOperationException("Base block entity not found");
        }

        protected abstract AbstractContainerMenu newMenu(int var1, Inventory var2, Container var3, ContainerData var4);

        public boolean canPlaceItem(int index, ItemStack stack) {
            if (index == 5) {
                return false;
            }
            if (index < 4) {
                ItemStack itemStack = this.getItem(index);
                return itemStack.isEmpty() || itemStack.is(stack.getItem()) && itemStack.getCount() + stack.getCount() <= stack.getMaxStackSize();
            }
            ItemStack itemstack = this.getItem(4);
            return stack.getBurnTime(this.getRecipeType()) > 0 || stack.is(Items.BUCKET) && !itemstack.is(Items.BUCKET);
        }

        public void getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
            for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
                level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipeHolder -> {
                    Recipe patt0$temp = recipeHolder.value();
                    if (patt0$temp instanceof EnhancedForgeRecipe) {
                        EnhancedForgeRecipe recipe = (EnhancedForgeRecipe)patt0$temp;
                        BEntity.createExperience(level, popVec, entry.getIntValue(), recipe.getExperience());
                    } else {
                        Recipe patt1$temp = recipeHolder.value();
                        if (patt1$temp instanceof BlastingRecipe) {
                            BlastingRecipe recipe = (BlastingRecipe)patt1$temp;
                            BEntity.createExperience(level, popVec, entry.getIntValue(), recipe.getExperience());
                        }
                    }
                });
            }
        }

        private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
            int i = Mth.floor((float)((float)recipeIndex * experience));
            float f = Mth.frac((float)((float)recipeIndex * experience));
            if (f != 0.0f && Math.random() < (double)f) {
                ++i;
            }
            ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)i);
        }

        public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
            if (recipe != null) {
                this.recipesUsed.addTo((Object)recipe.id(), 1);
            }
        }

        @Nullable
        public RecipeHolder<?> getRecipeUsed() {
            return null;
        }

        protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.loadAdditional(tag, registries);
            if (((StateProperties.HorizontalTwoPart)this.getBlockState().getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isBase()) {
                this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
                ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
                this.litTime = tag.getInt("BurnTime");
                this.cookingProgress = tag.getInt("CookTime");
                this.cookingTotalTime = tag.getInt("CookTimeTotal");
                this.litDuration = this.getBurnDuration((ItemStack)this.items.get(4));
                CompoundTag compoundtag = tag.getCompound("RecipesUsed");
                for (String s : compoundtag.getAllKeys()) {
                    this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
                }
            }
        }

        protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
            super.saveAdditional(tag, registries);
            if (((StateProperties.HorizontalTwoPart)this.getBlockState().getValue((Property)StateProperties.HORIZONTAL_TWO_PART)).isBase()) {
                tag.putInt("BurnTime", this.litTime);
                tag.putInt("CookTime", this.cookingProgress);
                tag.putInt("CookTimeTotal", this.cookingTotalTime);
                ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
                CompoundTag compoundtag = new CompoundTag();
                this.recipesUsed.forEach((id, amount) -> compoundtag.putInt(id.toString(), amount.intValue()));
                tag.put("RecipesUsed", (Tag)compoundtag);
            }
        }
    }
}

