/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.functional.crafting;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.crafting.HardmodeForgeBlock;

public class TitaniumForgeBlock
extends HardmodeForgeBlock {
    public TitaniumForgeBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHERITE_BLOCK).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 7).noOcclusion());
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState blockState;
        double rz;
        double rx;
        super.animateTick(state, level, pos, random);
        Direction facing = (Direction)state.getValue((Property)FACING);
        StateProperties.HorizontalTwoPart part = (StateProperties.HorizontalTwoPart)state.getValue((Property)PART);
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 1.8875;
        double z = (double)pos.getZ() + 0.5;
        boolean axisX = facing.getAxis() == Direction.Axis.X;
        boolean positive = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        double off = positive ? 0.3125 : -0.3125;
        double v1 = random.nextDouble() * off;
        double v2 = random.nextDouble() * off;
        if (axisX) {
            rx = x - ((double)facing.getStepX() * 0.25 + v1);
            rz = part.isBase() ? z + v2 + 0.125 : z + (double)facing.getCounterClockWise().getStepZ() * 0.625 - v2;
        } else {
            rz = z - ((double)facing.getStepZ() * 0.25 + v1);
            rx = part.isBase() ? x - v2 - 0.125 : x + (double)facing.getCounterClockWise().getStepX() * 0.625 + v2;
        }
        boolean soul = part.isBase() ? (Boolean)state.getValue((Property)BlockStateProperties.LIT) : (blockState = level.getBlockState(pos.relative(StateProperties.HorizontalTwoPart.getConnectedDirection((BlockState)state)))).is((Block)this) && (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false;
        level.addParticle((ParticleOptions)(soul ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME), rx, y, rz, 0.0, 0.02, 0.0);
    }
}

