/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.confluence.mod.common.init.ModTags;

public class BaseDroopingPlantsHeadBlock
extends GrowingPlantHeadBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<BaseDroopingPlantsHeadBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("side").forGetter(baseDroopingPlantsheadBlock -> baseDroopingPlantsheadBlock.side), (App)Codec.INT.fieldOf("maxAge").forGetter(baseDroopingPlantsHeadBlock -> baseDroopingPlantsHeadBlock.maxAge), (App)Codec.BOOL.fieldOf("isNaturalGrowth").forGetter(baseDroopingPlantsheadBlock -> baseDroopingPlantsheadBlock.isNaturalGrowth), (App)Codec.BOOL.fieldOf("isClimbable").forGetter(baseDroopingPlantsheadBlock -> baseDroopingPlantsheadBlock.isClimbable), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("attachedBlock").forGetter(baseDroopingPlantsheadBlock -> Arrays.asList(baseDroopingPlantsheadBlock.attachedBlock))).apply((Applicative)builder, (side, maxAge, isNaturalGrowth, isClimbable, attachedBlock) -> new BaseDroopingPlantsHeadBlock((int)side, (int)maxAge, (boolean)isNaturalGrowth, (boolean)isClimbable, attachedBlock.toArray(new Block[0]))));
    public static final int DEFAULT_MAX_AGE = 25;
    protected static VoxelShape SHAPE;
    private final boolean isNaturalGrowth;
    private final int side;
    private final int maxAge;
    private final Block[] attachedBlock;
    private final boolean isClimbable;
    private static final BooleanProperty WATERLOGGED;

    public BaseDroopingPlantsHeadBlock(int side, boolean isNaturalGrowth, boolean isClimbable) {
        super(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY), Direction.DOWN, SHAPE, false, 0.1);
        this.isNaturalGrowth = isNaturalGrowth;
        this.side = side;
        this.isClimbable = isClimbable;
        this.attachedBlock = new Block[0];
        this.maxAge = 25;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BaseDroopingPlantsHeadBlock(int side, boolean isNaturalGrowth, boolean isClimbable, Block ... attachedBlock) {
        super(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY), Direction.DOWN, SHAPE, false, 0.1);
        this.isNaturalGrowth = isNaturalGrowth;
        this.side = side;
        this.isClimbable = isClimbable;
        this.attachedBlock = attachedBlock;
        this.maxAge = 25;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BaseDroopingPlantsHeadBlock(int side, int maxAge, boolean isNaturalGrowth, boolean isClimbable, Block ... attachedBlock) {
        super(BlockBehaviour.Properties.of().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY), Direction.DOWN, SHAPE, false, 0.1);
        this.isNaturalGrowth = isNaturalGrowth;
        this.side = side;
        this.isClimbable = isClimbable;
        this.attachedBlock = attachedBlock;
        this.maxAge = maxAge;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BaseDroopingPlantsHeadBlock> codec() {
        return CODEC;
    }

    protected Block getBodyBlock() {
        return this;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)random);
    }

    protected boolean canGrowInto(BlockState state) {
        return NetherVines.isValidGrowthState((BlockState)state);
    }

    public boolean isRandomlyTicking(BlockState state) {
        if (this.maxAge != 25) {
            return (Integer)state.getValue((Property)AGE) < this.maxAge;
        }
        return this.isNaturalGrowth;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(LevelAccessor level) {
        if (this.maxAge != 0) {
            return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(this.maxAge)));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(25)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(pos);
        if (blockState.getFluidState().is((Fluid)Fluids.WATER)) {
            state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos blockPos;
        if (this.maxAge == 0) {
            super.randomTick(state, level, pos, random);
            return;
        }
        if ((Integer)state.getValue((Property)AGE) >= this.maxAge) {
            return;
        }
        if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(this.growthDirection), (BlockState)state, (random.nextDouble() < 0.1 ? 1 : 0) != 0) && this.canGrowInto(level.getBlockState(blockPos = pos.relative(this.growthDirection)))) {
            level.setBlockAndUpdate(blockPos, this.getGrowIntoState(state, level.random));
        }
    }

    public boolean canSurvive(BlockState blockstate, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        blockstate = level.getBlockState(blockpos);
        if (this.attachedBlock.length > 0) {
            return blockstate.is((Block)this) || Arrays.asList(this.attachedBlock).contains(blockstate.getBlock());
        }
        return blockstate.is((Block)this) || blockstate.is(ModTags.Blocks.DROOPING_VINE_CAN_SURVIVE);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        double halfSide = (double)(16 - this.side) / 2.0;
        SHAPE = Block.box((double)halfSide, (double)0.0, (double)halfSide, (double)(16.0 - halfSide), (double)16.0, (double)(16.0 - halfSide));
        return SHAPE;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.isClimbable && (state.is(BlockTags.CLIMBABLE) || state.is((Block)this));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
    }
}

