/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import org.confluence.mod.common.init.ModTags;

public class BaseMossBlock
extends MultifaceBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BaseMossBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("lightLevel").forGetter(baseMossBlock -> baseMossBlock.lightLevel), (App)Codec.BOOL.fieldOf("isLavaLogged").forGetter(baseMossBlock -> baseMossBlock.isIgnitedByLava)).apply((Applicative)builder, BaseMossBlock::new));
    private final int lightLevel;
    private final boolean isIgnitedByLava;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public BaseMossBlock(int lightLevel) {
        super(BlockBehaviour.Properties.of().lightLevel(BaseMossBlock.emission(lightLevel)).noCollission().ignitedByLava().pushReaction(PushReaction.DESTROY).strength(0.2f).sound(SoundType.GLOW_LICHEN).replaceable());
        this.lightLevel = lightLevel;
        this.isIgnitedByLava = true;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BaseMossBlock(int lightLevel, boolean isIgnitedByLava) {
        super(BlockBehaviour.Properties.of().lightLevel(BaseMossBlock.emission(lightLevel)).noCollission().pushReaction(PushReaction.DESTROY).strength(0.2f).sound(SoundType.GLOW_LICHEN).replaceable());
        this.lightLevel = lightLevel;
        this.isIgnitedByLava = isIgnitedByLava;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static ToIntFunction<BlockState> emission(int lightLevel) {
        return face -> MultifaceBlock.hasAnyFace((BlockState)face) ? lightLevel : 0;
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.getItemInHand().is(ModTags.Items.MOSS_ITEM) || super.canBeReplaced(state, useContext);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return Direction.stream().anyMatch(p_153316_ -> this.spreader.canSpreadInAnyDirection(state, (BlockGetter)level, pos, p_153316_.getOpposite()));
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.spreader.spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, random);
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    protected MapCodec<BaseMossBlock> codec() {
        return CODEC;
    }
}

