/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.jetbrains.annotations.NotNull;

public class BasePlantBlock
extends BushBlock {
    public static final MapCodec<BasePlantBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BasePlantBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf("ground").forGetter(basePlantBlock -> Arrays.asList(basePlantBlock.survive))).apply((Applicative)builder, (prop, ground) -> new BasePlantBlock((BlockBehaviour.Properties)prop, ground.toArray(new Block[0]))));
    private final Block[] survive;

    public BasePlantBlock(Block ... survive) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).replaceable());
        this.survive = survive;
    }

    public BasePlantBlock(BlockBehaviour.Properties prop, Block ... survive) {
        super(prop);
        this.survive = survive;
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return BasePlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0).move(offset.x, offset.y, offset.z);
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return Arrays.stream(this.survive).anyMatch(state -> state == groundState.getBlock());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!this.canSurvive(this.defaultBlockState(), (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.defaultBlockState();
    }

    @NotNull
    public BlockState updateShape(BlockState originState, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        ISpreadable.Type type;
        BlockState after = super.updateShape(originState, facing, facingState, level, currentPos, facingPos);
        if (facing != Direction.DOWN) {
            return after;
        }
        Block block = facingState.getBlock();
        if (block instanceof ISpreadable) {
            ISpreadable sp = (ISpreadable)block;
            type = sp.getSpreadType();
        } else {
            type = ISpreadable.Type.PURE;
        }
        ISpreadable.Type type2 = type;
        BlockState transformResult = type2.getNotNull(originState);
        return transformResult.canSurvive((LevelReader)level, currentPos) ? transformResult : Blocks.AIR.defaultBlockState();
    }
}

