/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.common.block.HorizontalDirectionalWithHorizontalFourPartBlock;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.init.ModFluids;
import org.jetbrains.annotations.Nullable;

public class BlinkingRoyalShimmerlilyBlock
extends HorizontalDirectionalWithHorizontalFourPartBlock {
    private static final VoxelShape A_SHAPE = BlinkingRoyalShimmerlilyBlock.box((double)3.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)13.0);
    private static final VoxelShape B_SHAPE = BlinkingRoyalShimmerlilyBlock.box((double)3.0, (double)-1.0, (double)3.0, (double)16.0, (double)0.0, (double)16.0);
    private static final VoxelShape C_SHAPE = BlinkingRoyalShimmerlilyBlock.box((double)0.0, (double)-1.0, (double)3.0, (double)13.0, (double)0.0, (double)16.0);
    private static final VoxelShape D_SHAPE = BlinkingRoyalShimmerlilyBlock.box((double)0.0, (double)-1.0, (double)0.0, (double)13.0, (double)0.0, (double)13.0);
    private static final VoxelShape[] BASE_SHAPES = new VoxelShape[]{A_SHAPE, B_SHAPE, C_SHAPE, D_SHAPE};
    private static final VoxelShape[] RIGHT_SHAPES = new VoxelShape[]{D_SHAPE, A_SHAPE, B_SHAPE, C_SHAPE};
    private static final VoxelShape[] CORNER_SHAPES = new VoxelShape[]{C_SHAPE, D_SHAPE, A_SHAPE, B_SHAPE};
    private static final VoxelShape[] FRONT_SHAPES = new VoxelShape[]{B_SHAPE, C_SHAPE, D_SHAPE, A_SHAPE};

    public BlinkingRoyalShimmerlilyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return switch ((StateProperties.HorizontalFourPart)state.getValue((Property)PART)) {
            default -> throw new MatchException(null, null);
            case StateProperties.HorizontalFourPart.BASE -> BASE_SHAPES[index];
            case StateProperties.HorizontalFourPart.RIGHT -> RIGHT_SHAPES[index];
            case StateProperties.HorizontalFourPart.FRONT -> FRONT_SHAPES[index];
            case StateProperties.HorizontalFourPart.CORNER -> CORNER_SHAPES[index];
        };
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).getFluidState().getType().getFluidType() == ModFluids.SHIMMER.type().get();
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!level.isClientSide() && direction == Direction.DOWN) {
            level.scheduleTick(pos, (Block)this, 2);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public static class BItem
    extends BlockItem {
        public BItem(Block block) {
            super(block, new Item.Properties());
        }

        public InteractionResult onItemUseFirst(ItemStack itemstack, UseOnContext context) {
            BlockState blockstate1;
            Player player = context.getPlayer();
            if (player == null || context.getLevel().isClientSide) {
                return super.onItemUseFirst(itemstack, context);
            }
            Level level = context.getLevel();
            BlockHitResult blockhitresult = BItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (blockhitresult.getType() == HitResult.Type.MISS) {
                return InteractionResult.PASS;
            }
            if (blockhitresult.getType() != HitResult.Type.BLOCK) {
                return InteractionResult.PASS;
            }
            BlockPos blockpos = blockhitresult.getBlockPos();
            Direction direction = blockhitresult.getDirection();
            BlockPos blockpos1 = blockpos.relative(direction);
            if (level.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack) && (blockstate1 = level.getBlockState(blockpos)).getFluidState().is((Fluid)ModFluids.SHIMMER.fluid().get())) {
                player.swing(context.getHand(), true);
                return this.useOn((UseOnContext)new BlockPlaceContext(player, context.getHand(), itemstack, new BlockHitResult(blockhitresult.getLocation(), direction, blockpos1, blockhitresult.isInside())));
            }
            return InteractionResult.FAIL;
        }
    }
}

