/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.block.NatureBlocks;

public class CattailsBodyBlock
extends GrowingPlantBodyBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final MapCodec<CattailsBodyBlock> CODEC = CattailsBodyBlock.simpleCodec(CattailsBodyBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public CattailsBodyBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, true);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<CattailsBodyBlock> codec() {
        return CODEC;
    }

    protected GrowingPlantHeadBlock getHeadBlock() {
        BlockState state = this.defaultBlockState();
        if (state.is((Block)NatureBlocks.CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.CATTAILS_HEAD.get();
        }
        if (state.is((Block)NatureBlocks.JUNGLE_CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.JUNGLE_CATTAILS_HEAD.get();
        }
        if (state.is((Block)NatureBlocks.GLOWING_MUSHROOM_CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.GLOWING_MUSHROOM_CATTAILS_HEAD.get();
        }
        if (state.is((Block)NatureBlocks.HALLOW_CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.HALLOW_CATTAILS_HEAD.get();
        }
        if (state.is((Block)NatureBlocks.EBONY_CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.EBONY_CATTAILS_HEAD.get();
        }
        if (state.is((Block)NatureBlocks.CRIMSON_CATTAILS_BODY.get())) {
            return (GrowingPlantHeadBlock)NatureBlocks.CRIMSON_CATTAILS_HEAD.get();
        }
        return (GrowingPlantHeadBlock)NatureBlocks.CATTAILS_HEAD.get();
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        boolean water = level.getBlockState(currentPos).getFluidState().is((Fluid)Fluids.WATER);
        if (facing == this.growthDirection.getOpposite() && !state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        GrowingPlantHeadBlock growingplantheadblock = this.getHeadBlock();
        if (facing == this.growthDirection && !facingState.is((Block)this) && !facingState.is((Block)growingplantheadblock)) {
            return this.updateHeadAfterConvertedFromBody(state, (BlockState)growingplantheadblock.getStateForPlacement(level).trySetValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water)));
        }
        if (this.scheduleFluidTicks) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }
}

