/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.init.block.NatureBlocks;

public class CattailsHeadBlock
extends GrowingPlantHeadBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final MapCodec<CattailsHeadBlock> CODEC = CattailsHeadBlock.simpleCodec(CattailsHeadBlock::new);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty PLACE = BooleanProperty.create((String)"place");
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    private static final int MAX_AGE = 3;

    public CattailsHeadBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, true, 0.2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(true))).setValue((Property)PLACE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int currentAge = (Integer)state.getValue((Property)AGE);
        BlockState lastState = this.getBodyBlock().defaultBlockState();
        BlockState aboveState = level.getBlockState(pos.above());
        boolean isAirUp = aboveState.isAir();
        boolean isAirNow = (Boolean)level.getBlockState(pos).getValue((Property)WATERLOGGED);
        if ((aboveState.isAir() || aboveState.is(Blocks.WATER)) && currentAge < 3) {
            if (isAirUp && isAirNow) {
                level.setBlock(pos.above(), (BlockState)((BlockState)state.trySetValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).trySetValue((Property)AGE, (Comparable)Integer.valueOf(random.nextInt(1, 4))), 3);
            } else {
                level.setBlock(pos.above(), (BlockState)((BlockState)state.trySetValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(!isAirUp))).trySetValue((Property)AGE, (Comparable)Integer.valueOf(isAirUp ? currentAge + 1 : 0)), 3);
            }
            level.setBlock(pos, (BlockState)lastState.trySetValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isAirNow)), 3);
        }
    }

    public BlockState getStateForPlacement(LevelAccessor level) {
        return (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(level.getRandom().nextInt(3)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState newState;
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)PLACE, (Comparable)Boolean.valueOf(true));
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (fluidstate.is(FluidTags.WATER) && fluidstate.getAmount() == 8 && (newState = super.getStateForPlacement(context)) != null) {
            return (BlockState)((BlockState)newState.setValue((Property)PLACE, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    protected Block getBodyBlock() {
        BlockState state = this.defaultBlockState();
        if (state.is((Block)NatureBlocks.CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.CATTAILS_BODY.get();
        }
        if (state.is((Block)NatureBlocks.JUNGLE_CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.JUNGLE_CATTAILS_BODY.get();
        }
        if (state.is((Block)NatureBlocks.GLOWING_MUSHROOM_CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.GLOWING_MUSHROOM_CATTAILS_BODY.get();
        }
        if (state.is((Block)NatureBlocks.HALLOW_CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.HALLOW_CATTAILS_BODY.get();
        }
        if (state.is((Block)NatureBlocks.EBONY_CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.EBONY_CATTAILS_BODY.get();
        }
        if (state.is((Block)NatureBlocks.CRIMSON_CATTAILS_HEAD.get())) {
            return (Block)NatureBlocks.CRIMSON_CATTAILS_BODY.get();
        }
        return (Block)NatureBlocks.CATTAILS_BODY.get();
    }

    protected boolean canAttachTo(BlockState state) {
        return !state.is(Blocks.MAGMA_BLOCK);
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState state) {
        return true;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.is(Blocks.AIR);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        boolean isWaterlogged;
        BlockPos blockpos = pos.relative(this.growthDirection);
        int currentAge = (Integer)state.getValue((Property)AGE);
        FluidState fluidState = level.getFluidState(blockpos);
        boolean bl = isWaterlogged = fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8;
        if (currentAge >= 3) {
            if (isWaterlogged || level.getBlockState(blockpos).is(Blocks.WATER)) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            }
            return;
        }
        BlockState targetState = level.getBlockState(blockpos);
        if (targetState.is(Blocks.WATER) || this.canGrowInto(targetState)) {
            BlockState newGrowState = (BlockState)this.getGrowIntoState(state, random).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
            level.setBlockAndUpdate(blockpos, newGrowState);
        }
    }

    protected MapCodec<CattailsHeadBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, AGE, PLACE, WATERLOGGED});
    }
}

