/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.mod.common.block.natural.CloudBlock;

public class CloudBlockTrampoline
extends CloudBlock {
    public static final IntegerProperty HIGH = IntegerProperty.create((String)"high", (int)0, (int)10);
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    })));

    public CloudBlockTrampoline(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HIGH, (Comparable)Integer.valueOf(0))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            BlockPos adjacentPos = blockpos.relative(entry.getKey());
            BlockState adjacentState = blockgetter.getBlockState(adjacentPos);
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(this.connectsTo(adjacentState, entry.getKey().getOpposite())));
        }
        return state;
    }

    public boolean connectsTo(BlockState state, Direction direction) {
        return state.is((Block)this);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.getAxis().getPlane() == Direction.Plane.HORIZONTAL) {
            for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
                BlockPos adjacentPos = currentPos.relative(entry.getKey());
                BlockState adjacentState = level.getBlockState(adjacentPos);
                boolean connected = this.connectsTo(adjacentState, entry.getKey().getOpposite());
                state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(connected));
            }
            return state;
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int currentHigh = (Integer)state.getValue((Property)HIGH);
            boolean isSteppingCarefully = livingEntity.isSteppingCarefully();
            if (isSteppingCarefully) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HIGH, (Comparable)Integer.valueOf(0)));
                livingEntity.setDeltaMovement(0.0, 0.0, 0.0);
            } else {
                int newHigh = Math.min(currentHigh + 1, 10);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HIGH, (Comparable)Integer.valueOf(newHigh)));
                livingEntity.setDeltaMovement(livingEntity.getDeltaMovement().add(0.0, (double)currentHigh, 0.0));
            }
            level.scheduleTick(pos, (Block)this, 20);
        }
        super.stepOn(level, pos, state, entity);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        AABB detectionArea = new AABB((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 513), (double)(pos.getZ() + 1));
        boolean hasPlayer = level.getEntitiesOfClass(LivingEntity.class, detectionArea).stream().anyMatch(LivingEntity::isAlive);
        if (!hasPlayer) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HIGH, (Comparable)Integer.valueOf(0)));
        }
        level.scheduleTick(pos, (Block)this, 20);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HIGH, NORTH, EAST, SOUTH, WEST});
    }
}

