/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.terraentity.init.TETags;

public class CorrodedWormRootsBlock
extends Block {
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    })));

    public CorrodedWormRootsBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockgetter = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
            BlockPos adjacentPos = blockpos.relative(entry.getKey());
            BlockState adjacentState = blockgetter.getBlockState(adjacentPos);
            state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(this.connectsTo(adjacentState, entry.getKey().getOpposite())));
        }
        return state;
    }

    public boolean connectsTo(BlockState state, Direction direction) {
        return state.is((Block)this) || state.is((Block)NatureBlocks.EBONY_LOG_BLOCKS.LOG.get());
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState stateBelow = level.getBlockState(pos.below());
        return stateBelow.is(ModTags.Blocks.CORRODED_WORM_ROOTS_BASE_BLOCK);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        if (facing.getAxis().getPlane() == Direction.Plane.HORIZONTAL) {
            for (Map.Entry<Direction, BooleanProperty> entry : PROPERTY_BY_DIRECTION.entrySet()) {
                BlockPos adjacentPos = currentPos.relative(entry.getKey());
                BlockState adjacentState = level.getBlockState(adjacentPos);
                boolean connected = this.connectsTo(adjacentState, entry.getKey().getOpposite());
                state = (BlockState)state.setValue((Property)entry.getValue(), (Comparable)Boolean.valueOf(connected));
            }
            return state;
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        double radius = 100.0;
        if (entity instanceof Player && (player = (Player)entity).isAlive() && !level.isClientSide) {
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 1000, 1));
            player.addEffect(new MobEffectInstance(MobEffects.POISON, 1000, 1));
            List corruptEntity = level.getEntitiesOfClass(Mob.class, new AABB(pos).inflate(radius), e -> e.getType().is(TETags.EntityTypes.CORRUPT));
            corruptEntity.forEach(e -> e.setTarget((LivingEntity)player));
        }
        super.stepOn(level, pos, state, entity);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST});
    }
}

