/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class GlowingMushroomPileusBlock
extends Block {
    public GlowingMushroomPileusBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(l -> 4));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PipeBlock.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.UP, (Comparable)Boolean.valueOf(false))).setValue((Property)PipeBlock.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PipeBlock.NORTH, PipeBlock.EAST, PipeBlock.SOUTH, PipeBlock.WEST, PipeBlock.UP, PipeBlock.DOWN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level blockGetter = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = blockGetter.getBlockState(neighborPos);
            state = (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(neighborState)));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return (BlockState)state.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.connectsTo(neighborState)));
    }

    private boolean connectsTo(BlockState state) {
        return state.getBlock() == this;
    }
}

