/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.terraentity.entity.monster.LittleHornet;
import org.confluence.terraentity.init.entity.TEMonsterEntities;

public class JungleHiveBlock
extends Block {
    public static final BooleanProperty NATURAL = BooleanProperty.create((String)"natural");

    public JungleHiveBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NATURAL, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NATURAL});
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        if (level.isClientSide || player.hasInfiniteMaterials() || !((Boolean)state.getValue((Property)NATURAL)).booleanValue()) {
            return;
        }
        int randomNumber = level.random.nextInt(3);
        if (randomNumber == 0) {
            level.setBlockAndUpdate(pos, ((LiquidBlock)ModBlocks.HONEY.get()).defaultBlockState());
        } else if (randomNumber == 1) {
            LittleHornet BeeEntity = (LittleHornet)((EntityType)TEMonsterEntities.LITTLE_HORNET.get()).create(level);
            if (BeeEntity != null) {
                BeeEntity.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5);
                level.addFreshEntity((Entity)BeeEntity);
                BeeEntity.setTarget((LivingEntity)player);
            }
        } else if (randomNumber == 2) {
            super.playerDestroy(level, player, pos, state, blockEntity, tool);
        }
    }
}

