/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.apache.commons.lang3.function.TriFunction;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ModItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogBlockSet {
    public static final Map<Block, Block> WRAPPED_STRIP_TABLE = new Hashtable<Block, Block>();
    public static final List<LogBlockSet> LOG_BLOCK_SETS = new ArrayList<LogBlockSet>();
    private static Block[] SIGN_BLOCKS;
    private static Block[] HANGING_SIGN_BLOCKS;
    public final String id;
    public final boolean ignitedByLava;
    public final DeferredBlock<Block> PLANKS;
    public final DeferredBlock<RotatedPillarBlock> LOG;
    public final DeferredBlock<RotatedPillarBlock> STRIPPED_LOG;
    public final DeferredBlock<LeavesBlock> LEAVES;
    public final DeferredBlock<RotatedPillarBlock> WOOD;
    public final DeferredBlock<RotatedPillarBlock> STRIPPED_WOOD;
    public final DeferredBlock<ButtonBlock> BUTTON;
    public final DeferredBlock<FenceBlock> FENCE;
    public final DeferredBlock<FenceGateBlock> FENCE_GATE;
    public final DeferredBlock<PressurePlateBlock> PRESSURE_PLATE;
    public final DeferredBlock<SlabBlock> SLAB;
    public final DeferredBlock<StairBlock> STAIRS;
    public final DeferredBlock<StandingSignBlock> SIGN;
    public final DeferredBlock<WallSignBlock> WALL_SIGN;
    public final DeferredItem<SignItem> SIGN_ITEM;
    public final DeferredBlock<TrapDoorBlock> TRAPDOOR;
    public final DeferredBlock<DoorBlock> DOOR;
    public final DeferredBlock<CeilingHangingSignBlock> HANGING_SIGN;
    public final DeferredBlock<WallHangingSignBlock> WALL_HANGING_SIGN;
    public final DeferredItem<HangingSignItem> HANGING_SIGN_ITEM;
    public final DeferredBlock<Block> CHISELED_PLANKS;
    public final DeferredBlock<SaplingBlock> SAPLING;

    LogBlockSet(Builder builder) {
        if (builder.log == null && builder.strippedLog != null || builder.wood == null && builder.strippedWood != null) {
            throw new NullPointerException();
        }
        this.id = builder.id;
        this.ignitedByLava = builder.ignitedByLava;
        this.PLANKS = ModBlocks.registerWithItem(this.id + "_planks", () -> builder.planks.apply(this.ignitedByLava(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD))));
        this.LOG = LogBlockSet.register(builder.log, this.id + "_log", true, this.ignitedByLava(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD)));
        this.STRIPPED_LOG = LogBlockSet.register(builder.strippedLog, "stripped_" + this.id + "_log", true, () -> this.ignitedByLava(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.LOG.get()))));
        this.LEAVES = LogBlockSet.register(builder.leaves, this.id + "_leaves", true, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(LogBlockSet::valid).isSuffocating(LogBlockSet::never).isViewBlocking(LogBlockSet::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(LogBlockSet::never));
        this.WOOD = LogBlockSet.register(builder.wood, this.id + "_wood", true, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD));
        this.STRIPPED_WOOD = LogBlockSet.register(builder.strippedWood, "stripped_" + this.id + "_wood", true, () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.WOOD.get())));
        this.BUTTON = LogBlockSet.register(builder.button, this.id + "_button", true, BlockBehaviour.Properties.of().noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY));
        this.FENCE = LogBlockSet.register(builder.fence, this.id + "_fence", true, () -> this.ignitedByLava(BlockBehaviour.Properties.of().forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).mapColor(((Block)this.PLANKS.get()).defaultMapColor())));
        this.FENCE_GATE = LogBlockSet.register(builder.fenceGate, this.id + "_fence_gate", true, () -> this.ignitedByLava(BlockBehaviour.Properties.of().forceSolidOn().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).mapColor(((Block)this.PLANKS.get()).defaultMapColor())));
        this.PRESSURE_PLATE = LogBlockSet.register(builder.pressurePlate, this.id + "_pressure_plate", true, () -> this.ignitedByLava(BlockBehaviour.Properties.of().forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY).mapColor(((Block)this.PLANKS.get()).defaultMapColor())));
        this.SLAB = LogBlockSet.register(builder.slab, this.id + "_slab", true, this.ignitedByLava(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD)));
        this.STAIRS = builder.stairs == null ? DeferredBlock.createBlock(Confluence.asResourceKey(Registries.BLOCK, this.id + "_stairs")) : ModBlocks.registerWithItem(this.id + "_stairs", () -> builder.stairs.apply(((Block)this.PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.PLANKS.get()))));
        this.SIGN = LogBlockSet.register(builder.staindingSign, this.id + "_sign", false, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f));
        this.WALL_SIGN = LogBlockSet.register(builder.wallSign, this.id + "_wall_sign", false, () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).lootFrom(this.SIGN));
        this.SIGN_ITEM = builder.signItem == null ? DeferredItem.createItem(Confluence.asResourceKey(Registries.ITEM, this.id + "_sign")) : ModItems.BLOCK_ITEMS.register(this.id + "_sign", () -> (SignItem)builder.signItem.apply((Object)new Item.Properties().stacksTo(16), (Object)((StandingSignBlock)this.SIGN.get()), (Object)((WallSignBlock)this.WALL_SIGN.get())));
        this.TRAPDOOR = LogBlockSet.register(builder.trapdoor, this.id + "_trapdoor", true, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().isValidSpawn(LogBlockSet::never).ignitedByLava());
        this.DOOR = LogBlockSet.register(builder.door, this.id + "_door", true, () -> BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY).ignitedByLava().mapColor(((Block)this.PLANKS.get()).defaultMapColor()));
        this.HANGING_SIGN = LogBlockSet.register(builder.ceilingHangingSign, this.id + "_hanging_sign", false, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava());
        this.WALL_HANGING_SIGN = LogBlockSet.register(builder.wallHangingSign, this.id + "_wall_hanging_sign", false, () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(1.0f).ignitedByLava().lootFrom(this.HANGING_SIGN));
        this.HANGING_SIGN_ITEM = builder.hangingSignItem == null ? DeferredItem.createItem(Confluence.asResourceKey(Registries.ITEM, this.id + "_hanging_sign")) : ModItems.BLOCK_ITEMS.register(this.id + "_hanging_sign", () -> (HangingSignItem)builder.hangingSignItem.apply((Object)((CeilingHangingSignBlock)this.HANGING_SIGN.get()), (Object)((WallHangingSignBlock)this.WALL_HANGING_SIGN.get()), (Object)new Item.Properties().stacksTo(16)));
        this.CHISELED_PLANKS = LogBlockSet.register(builder.chiseledPlanks, "chiseled_" + this.id + "_planks", true, () -> this.ignitedByLava(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)this.PLANKS.get()))));
        this.SAPLING = builder.sapling == null ? DeferredBlock.createBlock(Confluence.asResourceKey(Registries.BLOCK, this.id + "_sapling")) : ModBlocks.registerWithItem(this.id + "_sapling", () -> builder.sapling.apply(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    }

    public Stream<Item> getAllItems() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this.PLANKS, this.LOG, this.STRIPPED_LOG, this.LEAVES, this.WOOD, this.STRIPPED_WOOD, this.BUTTON, this.FENCE, this.FENCE_GATE, this.PRESSURE_PLATE, this.SLAB, this.STAIRS, this.TRAPDOOR, this.DOOR, this.SAPLING).filter(DeferredHolder::isBound).map(DeferredBlock::asItem), Stream.of(this.SIGN_ITEM, this.HANGING_SIGN_ITEM).filter(DeferredHolder::isBound).map(DeferredItem::asItem)});
    }

    private static <B extends Block> DeferredBlock<B> register(@Nullable Function<BlockBehaviour.Properties, ? extends B> function, String name, boolean withItem, BlockBehaviour.Properties properties) {
        return LogBlockSet.register(function, name, withItem, () -> properties);
    }

    private static <B extends Block> DeferredBlock<B> register(@Nullable Function<BlockBehaviour.Properties, ? extends B> function, String name, boolean withItem, Supplier<BlockBehaviour.Properties> properties) {
        if (function == null) {
            return DeferredBlock.createBlock(Confluence.asResourceKey(Registries.BLOCK, name));
        }
        Supplier<Block> supplier = () -> (Block)function.apply((BlockBehaviour.Properties)properties.get());
        return withItem ? ModBlocks.registerWithItem(name, supplier) : ModBlocks.registerWithoutItem(name, supplier);
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static boolean valid(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
        return entityType == EntityType.OCELOT || entityType == EntityType.PARROT;
    }

    private static boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    private BlockBehaviour.Properties ignitedByLava(BlockBehaviour.Properties properties) {
        return this.ignitedByLava ? properties.ignitedByLava() : properties;
    }

    public static Builder builder(String id, boolean ignitedByLava, WoodSetType woodSetType) {
        return new Builder(id, ignitedByLava, woodSetType);
    }

    public static void acceptTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> provider) {
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> completes = provider.apply((TagKey<Block>)BlockTags.COMPLETES_FIND_TREE_TUTORIAL);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> burn = provider.apply((TagKey<Block>)BlockTags.LOGS_THAT_BURN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> logs = provider.apply((TagKey<Block>)BlockTags.LOGS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> planks = provider.apply((TagKey<Block>)BlockTags.PLANKS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> buttons = provider.apply((TagKey<Block>)BlockTags.BUTTONS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenButtons = provider.apply((TagKey<Block>)BlockTags.WOODEN_BUTTONS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> stairs = provider.apply((TagKey<Block>)BlockTags.STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenStairs = provider.apply((TagKey<Block>)BlockTags.WOODEN_STAIRS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> slabs = provider.apply((TagKey<Block>)BlockTags.SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenSlabs = provider.apply((TagKey<Block>)BlockTags.WOODEN_SLABS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> fences = provider.apply((TagKey<Block>)BlockTags.FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenFences = provider.apply((TagKey<Block>)BlockTags.WOODEN_FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> cFences = provider.apply((TagKey<Block>)Tags.Blocks.FENCES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> cFencesWooden = provider.apply((TagKey<Block>)Tags.Blocks.FENCES_WOODEN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> fenceGates = provider.apply((TagKey<Block>)BlockTags.FENCE_GATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> cFenceGates = provider.apply((TagKey<Block>)Tags.Blocks.FENCE_GATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> cFenceGatesWooden = provider.apply((TagKey<Block>)Tags.Blocks.FENCE_GATES_WOODEN);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> trapdoors = provider.apply((TagKey<Block>)BlockTags.TRAPDOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenTrapdoors = provider.apply((TagKey<Block>)BlockTags.WOODEN_TRAPDOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenPressurePlates = provider.apply((TagKey<Block>)BlockTags.WOODEN_PRESSURE_PLATES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> doors = provider.apply((TagKey<Block>)BlockTags.DOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> woodenDoors = provider.apply((TagKey<Block>)BlockTags.WOODEN_DOORS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> leaves = provider.apply((TagKey<Block>)BlockTags.LEAVES);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> standingSigns = provider.apply((TagKey<Block>)BlockTags.STANDING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> wallSigns = provider.apply((TagKey<Block>)BlockTags.WALL_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> signs = provider.apply((TagKey<Block>)BlockTags.SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> cStrippedLogs = provider.apply((TagKey<Block>)Tags.Blocks.STRIPPED_LOGS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> ceilingHangingSigns = provider.apply((TagKey<Block>)BlockTags.CEILING_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> wallHangingSigns = provider.apply((TagKey<Block>)BlockTags.WALL_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> allHangingSigns = provider.apply((TagKey<Block>)BlockTags.ALL_HANGING_SIGNS);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block> saplings = provider.apply((TagKey<Block>)BlockTags.SAPLINGS);
        for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
            Block value;
            boolean ignitedByLava = logBlocks.ignitedByLava;
            Block planksBlock = (Block)logBlocks.PLANKS.get();
            planks.add((Object)planksBlock);
            if (logBlocks.LOG.isBound()) {
                value = (Block)logBlocks.LOG.get();
                completes.add((Object)value);
                if (ignitedByLava) {
                    burn.add((Object)value);
                }
                logs.add((Object)value);
            }
            if (logBlocks.STRIPPED_LOG.isBound()) {
                value = (Block)logBlocks.STRIPPED_LOG.get();
                completes.add((Object)value);
                if (ignitedByLava) {
                    burn.add((Object)value);
                }
                logs.add((Object)value);
                cStrippedLogs.add((Object)value);
            }
            if (logBlocks.WOOD.isBound()) {
                value = (Block)logBlocks.WOOD.get();
                completes.add((Object)value);
                if (ignitedByLava) {
                    burn.add((Object)value);
                }
                logs.add((Object)value);
            }
            if (logBlocks.STRIPPED_WOOD.isBound()) {
                value = (Block)logBlocks.STRIPPED_WOOD.get();
                completes.add((Object)value);
                if (ignitedByLava) {
                    burn.add((Object)value);
                }
                logs.add((Object)value);
            }
            if (logBlocks.LEAVES.isBound()) {
                value = (Block)logBlocks.LEAVES.get();
                completes.add((Object)value);
                leaves.add((Object)value);
            }
            if (logBlocks.BUTTON.isBound()) {
                value = (Block)logBlocks.BUTTON.get();
                buttons.add((Object)value);
                woodenButtons.add((Object)value);
            }
            if (logBlocks.FENCE.isBound()) {
                value = (Block)logBlocks.FENCE.get();
                fences.add((Object)value);
                woodenFences.add((Object)value);
                cFences.add((Object)value);
                cFencesWooden.add((Object)value);
            }
            if (logBlocks.FENCE_GATE.isBound()) {
                value = (Block)logBlocks.FENCE_GATE.get();
                fenceGates.add((Object)value);
                cFenceGates.add((Object)value);
                cFenceGatesWooden.add((Object)value);
            }
            if (logBlocks.PRESSURE_PLATE.isBound()) {
                value = (Block)logBlocks.PRESSURE_PLATE.get();
                woodenPressurePlates.add((Object)value);
            }
            if (logBlocks.SLAB.isBound()) {
                value = (Block)logBlocks.SLAB.get();
                slabs.add((Object)value);
                woodenSlabs.add((Object)value);
            }
            if (logBlocks.STAIRS.isBound()) {
                value = (Block)logBlocks.STAIRS.get();
                stairs.add((Object)value);
                woodenStairs.add((Object)value);
            }
            if (logBlocks.SIGN.isBound()) {
                value = (Block)logBlocks.SIGN.get();
                standingSigns.add((Object)value);
                signs.add((Object)value);
            }
            if (logBlocks.WALL_SIGN.isBound()) {
                value = (Block)logBlocks.WALL_SIGN.get();
                wallSigns.add((Object)value);
                signs.add((Object)value);
            }
            if (logBlocks.TRAPDOOR.isBound()) {
                value = (Block)logBlocks.TRAPDOOR.get();
                trapdoors.add((Object)value);
                woodenTrapdoors.add((Object)value);
            }
            if (logBlocks.DOOR.isBound()) {
                value = (Block)logBlocks.DOOR.get();
                doors.add((Object)value);
                woodenDoors.add((Object)value);
            }
            if (logBlocks.HANGING_SIGN.isBound()) {
                value = (Block)logBlocks.HANGING_SIGN.get();
                ceilingHangingSigns.add((Object)value);
                allHangingSigns.add((Object)value);
            }
            if (logBlocks.WALL_HANGING_SIGN.isBound()) {
                value = (Block)logBlocks.WALL_HANGING_SIGN.get();
                wallHangingSigns.add((Object)value);
                allHangingSigns.add((Object)value);
            }
            if (logBlocks.CHISELED_PLANKS.isBound()) {
                value = (Block)logBlocks.CHISELED_PLANKS.get();
                planks.add((Object)value);
            }
            if (!logBlocks.SAPLING.isBound()) continue;
            value = (Block)logBlocks.SAPLING.get();
            saplings.add((Object)value);
        }
    }

    public static void acceptBuilding(CreativeModeTab.Output output) {
        for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
            output.accept((ItemLike)logBlocks.PLANKS.get());
            if (logBlocks.STRIPPED_LOG.isBound()) {
                output.accept((ItemLike)logBlocks.STRIPPED_LOG.get());
            }
            if (logBlocks.WOOD.isBound()) {
                output.accept((ItemLike)logBlocks.WOOD.get());
            }
            if (logBlocks.STRIPPED_WOOD.isBound()) {
                output.accept((ItemLike)logBlocks.STRIPPED_WOOD.get());
            }
            if (logBlocks.BUTTON.isBound()) {
                output.accept((ItemLike)logBlocks.BUTTON.get());
            }
            if (logBlocks.FENCE.isBound()) {
                output.accept((ItemLike)logBlocks.FENCE.get());
            }
            if (logBlocks.FENCE_GATE.isBound()) {
                output.accept((ItemLike)logBlocks.FENCE_GATE.get());
            }
            if (logBlocks.PRESSURE_PLATE.isBound()) {
                output.accept((ItemLike)logBlocks.PRESSURE_PLATE.get());
            }
            if (logBlocks.SLAB.isBound()) {
                output.accept((ItemLike)logBlocks.SLAB.get());
            }
            if (logBlocks.STAIRS.isBound()) {
                output.accept((ItemLike)logBlocks.STAIRS.get());
            }
            if (logBlocks.SIGN_ITEM.isBound()) {
                output.accept((ItemLike)logBlocks.SIGN_ITEM.get());
            }
            if (logBlocks.TRAPDOOR.isBound()) {
                output.accept((ItemLike)logBlocks.TRAPDOOR.get());
            }
            if (logBlocks.DOOR.isBound()) {
                output.accept((ItemLike)logBlocks.DOOR.get());
            }
            if (logBlocks.HANGING_SIGN_ITEM.isBound()) {
                output.accept((ItemLike)logBlocks.HANGING_SIGN_ITEM.get());
            }
            if (!logBlocks.CHISELED_PLANKS.isBound()) continue;
            output.accept((ItemLike)logBlocks.CHISELED_PLANKS.get());
        }
    }

    public static void acceptNature(CreativeModeTab.Output output) {
        for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
            if (logBlocks.LOG.isBound()) {
                output.accept(logBlocks.LOG);
            }
            if (logBlocks.LEAVES.isBound()) {
                output.accept(logBlocks.LEAVES);
            }
            if (!logBlocks.SAPLING.isBound()) continue;
            output.accept(logBlocks.SAPLING);
        }
    }

    public static void wrapStrip() {
        for (LogBlockSet logBlockSet : LOG_BLOCK_SETS) {
            if (logBlockSet.LOG.isBound() && logBlockSet.STRIPPED_LOG.isBound()) {
                WRAPPED_STRIP_TABLE.put((Block)logBlockSet.LOG.get(), (Block)logBlockSet.STRIPPED_LOG.get());
            }
            if (!logBlockSet.WOOD.isBound() || !logBlockSet.STRIPPED_WOOD.isBound()) continue;
            WRAPPED_STRIP_TABLE.put((Block)logBlockSet.WOOD.get(), (Block)logBlockSet.STRIPPED_WOOD.get());
        }
    }

    public static Block[] getSignBlocks() {
        if (SIGN_BLOCKS == null) {
            ArrayList<Block> list = new ArrayList<Block>();
            for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
                if (logBlocks.SIGN.isBound()) {
                    list.add((Block)logBlocks.SIGN.get());
                }
                if (!logBlocks.WALL_SIGN.isBound()) continue;
                list.add((Block)logBlocks.WALL_SIGN.get());
            }
            SIGN_BLOCKS = list.toArray(new Block[0]);
        }
        return SIGN_BLOCKS;
    }

    public static Block[] getHangingSignBlocks() {
        if (HANGING_SIGN_BLOCKS == null) {
            ArrayList<Block> list = new ArrayList<Block>();
            for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
                if (logBlocks.HANGING_SIGN.isBound()) {
                    list.add((Block)logBlocks.HANGING_SIGN.get());
                }
                if (!logBlocks.WALL_HANGING_SIGN.isBound()) continue;
                list.add((Block)logBlocks.WALL_HANGING_SIGN.get());
            }
            HANGING_SIGN_BLOCKS = list.toArray(new Block[0]);
        }
        return HANGING_SIGN_BLOCKS;
    }

    public static void setFlammable() {
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        for (LogBlockSet logBlocks : LOG_BLOCK_SETS) {
            Block value;
            boolean ignitedByLava = logBlocks.ignitedByLava;
            if (ignitedByLava) {
                fireblock.setFlammable((Block)logBlocks.PLANKS.get(), 5, 20);
            }
            if (logBlocks.LOG.isBound()) {
                value = (Block)logBlocks.LOG.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 5);
                }
            }
            if (logBlocks.STRIPPED_LOG.isBound()) {
                value = (Block)logBlocks.STRIPPED_LOG.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 5);
                }
            }
            if (logBlocks.WOOD.isBound()) {
                value = (Block)logBlocks.WOOD.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 5);
                }
            }
            if (logBlocks.STRIPPED_WOOD.isBound()) {
                value = (Block)logBlocks.STRIPPED_WOOD.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 5);
                }
            }
            if (logBlocks.LEAVES.isBound()) {
                value = (Block)logBlocks.LEAVES.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 30, 60);
                }
            }
            if (logBlocks.FENCE.isBound()) {
                value = (Block)logBlocks.FENCE.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 20);
                }
            }
            if (logBlocks.FENCE_GATE.isBound()) {
                value = (Block)logBlocks.FENCE_GATE.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 20);
                }
            }
            if (logBlocks.SLAB.isBound()) {
                value = (Block)logBlocks.SLAB.get();
                if (ignitedByLava) {
                    fireblock.setFlammable(value, 5, 20);
                }
            }
            if (!logBlocks.STAIRS.isBound()) continue;
            value = (Block)logBlocks.STAIRS.get();
            if (!ignitedByLava) continue;
            fireblock.setFlammable(value, 5, 20);
        }
    }

    public static class Builder {
        private final String id;
        private final boolean ignitedByLava;
        private Function<BlockBehaviour.Properties, ? extends Block> planks = Block::new;
        private Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> log = RotatedPillarBlock::new;
        private Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> strippedLog = RotatedPillarBlock::new;
        private Function<BlockBehaviour.Properties, ? extends LeavesBlock> leaves = LeavesBlock::new;
        private Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> wood = RotatedPillarBlock::new;
        private Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> strippedWood = RotatedPillarBlock::new;
        private Function<BlockBehaviour.Properties, ? extends ButtonBlock> button;
        private Function<BlockBehaviour.Properties, ? extends FenceBlock> fence = FenceBlock::new;
        private Function<BlockBehaviour.Properties, ? extends FenceGateBlock> fenceGate;
        private Function<BlockBehaviour.Properties, ? extends PressurePlateBlock> pressurePlate;
        private Function<BlockBehaviour.Properties, ? extends SlabBlock> slab = SlabBlock::new;
        private BiFunction<BlockState, BlockBehaviour.Properties, ? extends StairBlock> stairs = StairBlock::new;
        private Function<BlockBehaviour.Properties, ? extends StandingSignBlock> staindingSign;
        private Function<BlockBehaviour.Properties, ? extends WallSignBlock> wallSign;
        private TriFunction<Item.Properties, StandingSignBlock, WallSignBlock, ? extends SignItem> signItem;
        private Function<BlockBehaviour.Properties, ? extends TrapDoorBlock> trapdoor;
        private Function<BlockBehaviour.Properties, ? extends DoorBlock> door;
        private Function<BlockBehaviour.Properties, ? extends CeilingHangingSignBlock> ceilingHangingSign;
        private Function<BlockBehaviour.Properties, ? extends WallHangingSignBlock> wallHangingSign;
        private TriFunction<CeilingHangingSignBlock, WallHangingSignBlock, Item.Properties, ? extends HangingSignItem> hangingSignItem;
        private Function<BlockBehaviour.Properties, ? extends Block> chiseledPlanks = Block::new;
        private Function<BlockBehaviour.Properties, ? extends SaplingBlock> sapling;

        public Builder(String id, boolean ignitedByLava, WoodSetType woodSetType) {
            this.id = id;
            this.ignitedByLava = ignitedByLava;
            this.button = properties -> new ButtonBlock(woodSetType.SET, 30, properties);
            this.fenceGate = properties -> new FenceGateBlock(woodSetType.TYPE, properties);
            this.pressurePlate = properties -> new PressurePlateBlock(woodSetType.SET, properties);
            this.staindingSign = properties -> new StandingSignBlock(woodSetType.TYPE, properties);
            this.wallSign = properties -> new WallSignBlock(woodSetType.TYPE, properties);
            this.signItem = SignItem::new;
            this.trapdoor = properties -> new TrapDoorBlock(woodSetType.SET, properties);
            this.door = properties -> new DoorBlock(woodSetType.SET, properties);
            this.ceilingHangingSign = properties -> new CeilingHangingSignBlock(woodSetType.TYPE, properties);
            this.wallHangingSign = properties -> new WallHangingSignBlock(woodSetType.TYPE, properties);
            this.hangingSignItem = HangingSignItem::new;
        }

        public Builder planks(@NotNull Function<BlockBehaviour.Properties, ? extends Block> function) {
            this.planks = function;
            return this;
        }

        public Builder log(@Nullable Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> function) {
            this.log = function;
            return this;
        }

        public Builder strippedLog(@Nullable Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> function) {
            this.strippedLog = function;
            return this;
        }

        public Builder leaves(@Nullable Function<BlockBehaviour.Properties, ? extends LeavesBlock> function) {
            this.leaves = function;
            return this;
        }

        public Builder wood(@Nullable Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> function) {
            this.wood = function;
            return this;
        }

        public Builder strippedWood(@Nullable Function<BlockBehaviour.Properties, ? extends RotatedPillarBlock> function) {
            this.strippedWood = function;
            return this;
        }

        public Builder button(@Nullable Function<BlockBehaviour.Properties, ? extends ButtonBlock> function) {
            this.button = function;
            return this;
        }

        public Builder fence(@Nullable Function<BlockBehaviour.Properties, ? extends FenceBlock> function) {
            this.fence = function;
            return this;
        }

        public Builder fenceGate(@Nullable Function<BlockBehaviour.Properties, ? extends FenceGateBlock> function) {
            this.fenceGate = function;
            return this;
        }

        public Builder pressurePlate(@Nullable Function<BlockBehaviour.Properties, ? extends PressurePlateBlock> function) {
            this.pressurePlate = function;
            return this;
        }

        public Builder slab(@Nullable Function<BlockBehaviour.Properties, ? extends SlabBlock> function) {
            this.slab = function;
            return this;
        }

        public Builder stair(@Nullable BiFunction<BlockState, BlockBehaviour.Properties, ? extends StairBlock> function) {
            this.stairs = function;
            return this;
        }

        public Builder sign(@Nullable Function<BlockBehaviour.Properties, ? extends StandingSignBlock> standingSign, @Nullable Function<BlockBehaviour.Properties, ? extends WallSignBlock> wallSign, @Nullable TriFunction<Item.Properties, StandingSignBlock, WallSignBlock, ? extends SignItem> signItem) {
            if (!(standingSign == null && wallSign == null && signItem == null || standingSign != null && wallSign != null && signItem != null)) {
                throw new NullPointerException();
            }
            this.staindingSign = standingSign;
            this.wallSign = wallSign;
            this.signItem = signItem;
            return this;
        }

        public Builder trapdoor(@Nullable Function<BlockBehaviour.Properties, ? extends TrapDoorBlock> function) {
            this.trapdoor = function;
            return this;
        }

        public Builder door(@Nullable Function<BlockBehaviour.Properties, ? extends DoorBlock> function) {
            this.door = function;
            return this;
        }

        public Builder hangingSign(@Nullable Function<BlockBehaviour.Properties, ? extends CeilingHangingSignBlock> ceilingHangingSign, @Nullable Function<BlockBehaviour.Properties, ? extends WallHangingSignBlock> wallHangingSign, @Nullable TriFunction<CeilingHangingSignBlock, WallHangingSignBlock, Item.Properties, ? extends HangingSignItem> hangingSignItem) {
            this.ceilingHangingSign = ceilingHangingSign;
            this.wallHangingSign = wallHangingSign;
            this.hangingSignItem = hangingSignItem;
            return this;
        }

        public Builder chiseledPlanks(@Nullable Function<BlockBehaviour.Properties, ? extends Block> function) {
            this.chiseledPlanks = function;
            return this;
        }

        public Builder sapling(@NotNull Function<BlockBehaviour.Properties, ? extends SaplingBlock> function) {
            this.sapling = function;
            return this;
        }

        public LogBlockSet build() {
            LogBlockSet logBlockSet = new LogBlockSet(this);
            LOG_BLOCK_SETS.add(logBlockSet);
            return logBlockSet;
        }
    }

    public static enum WoodSetType {
        EBONY("ebony"),
        PEARL("pearl"),
        SHADOW("shadow"),
        PALM("palm"),
        BAOBAB("baobab"),
        GLOWING_MUSHROOM("glowing_mushroom"),
        YELLOW_WILLOW("yellow_willow"),
        LIVING("living"),
        LIVING_MAHOGANY("living_mahogany"),
        ASH("ash"),
        DYNASTY("dynasty"),
        SPOOKY("spooky");

        public final BlockSetType SET;
        public final WoodType TYPE;

        private WoodSetType(String id) {
            id = Confluence.asPlainId(id);
            this.SET = BlockSetType.register((BlockSetType)new BlockSetType(id));
            this.TYPE = WoodType.register((WoodType)new WoodType(id, this.SET));
        }
    }
}

