/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.ConfluenceData;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.LightPetItems;
import org.confluence.mod.common.init.item.ManaWeaponItems;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.phase_journey.common.util.PhaseUtils;
import org.confluence.terra_guns.common.init.TGItems;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;
import org.confluence.terraentity.entity.boss.EaterOfWorlds;
import org.jetbrains.annotations.Nullable;

public class ShadowOrbBlock
extends Block {
    private static final VoxelShape SHAPE = ShadowOrbBlock.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);

    public ShadowOrbBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().pushReaction(PushReaction.DESTROY));
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = pos.getCenter();
            ConfluenceData data = ConfluenceData.get(serverLevel);
            int count = data.getEvilBrokenCount() % 3;
            PhaseUtils.achieveLevelPhase((ServerLevel)serverLevel, (ResourceLocation)Confluence.asResource("has_it_evil_ever_been_broken"), (boolean)true);
            if (count == 0 || level.random.nextFloat() < 0.2f) {
                LibUtils.createItemEntity((ItemStack)TGItems.MUSKET.toStack(), (double)center.x, (double)center.y, (double)center.z, (Level)level, (int)0);
                LibUtils.createItemEntity((ItemStack)TGItems.MUSKET_BULLET.toStack(100), (double)center.x, (double)center.y, (double)center.z, (Level)level, (int)0);
            }
            if (level.random.nextFloat() < 0.2f) {
                LibUtils.createItemEntity((ItemStack)LightPetItems.SHADOW_ORB.toStack(), (double)center.x, (double)center.y, (double)center.z, (Level)level, (int)0);
            }
            if (level.random.nextFloat() < 0.2f) {
                LibUtils.createItemEntity((ItemStack)ManaWeaponItems.VILETHRON.toStack(), (double)center.x, (double)center.y, (double)center.z, (Level)level, (int)0);
            }
            if (level.random.nextFloat() < 0.2f) {
                // empty if block
            }
            if (level.random.nextFloat() < 0.2f) {
                LibUtils.createItemEntity((ItemStack)AccessoryItems.BAND_OF_STARPOWER.toStack(), (double)center.x, (double)center.y, (double)center.z, (Level)level, (int)0);
            }
            for (ServerPlayer player : serverLevel.getPlayers(serverPlayer -> serverPlayer.distanceToSqr(center) <= 1024.0)) {
                AchievementUtils.awardAchievement(player, "smashing_poppet");
            }
            if (count != 2) {
                MutableComponent component = Component.translatable((String)("event.confluence.shadow_orb_broken." + count)).withColor(GlobalColors.MESSAGE.get());
                serverLevel.getServer().getPlayerList().broadcastSystemMessage((Component)component, false);
            }
            if (data.updateEvilBrokenCount()) {
                ModUtils.summonBoss(serverLevel, pos, (AbstractTerraBossBase)new EaterOfWorlds(level, true));
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(level, player, pos, state, blockEntity, tool);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AchievementUtils.awardAchievement(serverPlayer, "smashing_poppet");
        }
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }
}

