/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SwordInStoneBlock
extends Block {
    public static final EnumProperty<SwordType> SWORD_TYPE = EnumProperty.create((String)"sword_type", SwordType.class);
    private static final VoxelShape NULL_SHAPE = Shapes.or((VoxelShape)SwordInStoneBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape)SwordInStoneBlock.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0));
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)SwordInStoneBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), (VoxelShape[])new VoxelShape[]{SwordInStoneBlock.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), SwordInStoneBlock.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)});

    public SwordInStoneBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).instabreak());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(SWORD_TYPE, (Comparable)((Object)SwordType.NULL)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.getValue(SWORD_TYPE) == SwordType.NULL ? NULL_SHAPE : SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SWORD_TYPE});
    }

    public static enum SwordType implements StringRepresentable
    {
        NULL("null"),
        ENCHANTED_SWORD("enchanted_sword"),
        TERRAGRIM("terragrim"),
        ROTTEN_SWORD("rotten_sword");

        private final String name;

        private SwordType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

