/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TaperedTwoPartBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<TaperedTwoPart> PART = EnumProperty.create((String)"stalagmite_thickness", TaperedTwoPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TaperedTwoPartBlock() {
        super(BlockBehaviour.Properties.of().strength(1.0f).pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(PART, (Comparable)((Object)TaperedTwoPart.TIP_SINGLE)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, TIP_DIRECTION, PART});
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        Direction ownDirection = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (state.getValue(PART) == TaperedTwoPart.TIP_SINGLE && level.getBlockState(pos.relative(ownDirection)).is(this.asBlock()) && ownDirection == level.getBlockState(pos.relative(ownDirection)).getValue((Property)TIP_DIRECTION)) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)TaperedTwoPart.BASE));
        }
        if (state.getValue(PART) == TaperedTwoPart.BASE && level.getBlockState(pos.relative(ownDirection)).is(this.asBlock()) && ownDirection == level.getBlockState(pos.relative(ownDirection)).getValue((Property)TIP_DIRECTION)) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)TaperedTwoPart.BASE));
        }
        if (state.getValue(PART) == TaperedTwoPart.TIP_MERGE && level.getBlockState(pos.relative(ownDirection.getOpposite())).is(this.asBlock()) && ownDirection == level.getBlockState(pos.relative(ownDirection.getOpposite())).getValue((Property)TIP_DIRECTION)) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)TaperedTwoPart.TIP_MERGE));
        }
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)TaperedTwoPart.TIP_SINGLE));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction opposite;
        BlockPos blockpos;
        Level level = context.getLevel();
        Direction dir = this.calculateTipDirection((LevelReader)level, blockpos = context.getClickedPos(), opposite = context.getNearestLookingVerticalDirection().getOpposite());
        if (dir == null) {
            return null;
        }
        TaperedTwoPart part = this.calculatePart((LevelReader)level, blockpos, dir);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)dir)).setValue(PART, (Comparable)((Object)part))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = switch (((TaperedTwoPart)((Object)state.getValue(PART))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BASE_SHAPE;
            case 1, 2 -> state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP;
        };
        Vec3 offset = state.getOffset(level, pos);
        return shape.move(offset.x, 0.0, offset.z);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.isValidTaperedPlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && ((TaperedTwoPart)((Object)state.getValue(PART))).isTip()) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected float getMaxHorizontalOffset() {
        return 0.125f;
    }

    private boolean isValidTaperedPlacement(LevelReader level, BlockPos pos, Direction dir) {
        return level.getBlockState(pos.relative(dir.getOpposite())).isFaceSturdy((BlockGetter)level, pos.relative(dir.getOpposite()), dir) || level.getBlockState(pos.relative(dir.getOpposite())).is(this.asBlock()) && level.getBlockState(pos.relative(dir.getOpposite())).getValue(PART) == TaperedTwoPart.TIP_SINGLE;
    }

    @Nullable
    private Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        if (this.isValidTaperedPlacement(level, pos, dir)) {
            return dir;
        }
        return this.isValidTaperedPlacement(level, pos, dir.getOpposite()) ? dir.getOpposite() : null;
    }

    private TaperedTwoPart calculatePart(LevelReader level, BlockPos pos, Direction dir) {
        BlockState base = level.getBlockState(pos.relative(dir.getOpposite()));
        if (base.is((Block)this) && base.getValue((Property)TIP_DIRECTION) == dir && base.getValue(PART) == TaperedTwoPart.TIP_SINGLE) {
            return TaperedTwoPart.TIP_MERGE;
        }
        return TaperedTwoPart.TIP_SINGLE;
    }

    public static enum TaperedTwoPart implements StringRepresentable
    {
        BASE("base"),
        TIP_MERGE("tip_merge"),
        TIP_SINGLE("tip_single");

        private final String name;

        private TaperedTwoPart(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean isTip() {
            return this != BASE;
        }
    }
}

