/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.herbs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.block.natural.herbs.BaseHerbBlock;
import org.confluence.mod.common.init.item.FoodItems;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class Moonglow
extends BaseHerbBlock {
    public static final IntegerProperty PROP_LIGHT = IntegerProperty.create((String)"level", (int)3, (int)5);

    public Moonglow() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION).randomTicks().lightLevel(value -> (Integer)value.getValue((Property)AGE) == 2 ? (Integer)value.getValue((Property)PROP_LIGHT) : 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PROP_LIGHT});
    }

    @Override
    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)FoodItems.MOONGLOW_SEED.get();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int brightness;
        if (this.getAge(state) != 2) {
            return;
        }
        int r = random.nextInt(200);
        if (r < 10) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(5)));
            Vec3 center = pos.getCenter().offsetRandom(random, 0.6f);
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.7f, 1.0f), 1.0f), center.x, center.y / 2.0, center.z, 10.0, 10.0, 10.0);
            center = pos.getCenter().offsetRandom(random, 0.6f);
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.7f, 1.0f), 1.0f), center.x, center.y / 2.0, center.z, 10.0, 10.0, 10.0);
        } else if (r < 160 && (brightness = ((Integer)state.getValue((Property)PROP_LIGHT)).intValue()) > 3) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PROP_LIGHT, (Comparable)Integer.valueOf(brightness - 1)));
        }
    }

    @Override
    public boolean canBloom(ServerLevel level, BlockState state) {
        return LibDateUtils.isNight((Level)level);
    }
}

