/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.sapling;

import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BaseSaplingBlock
extends SaplingBlock {
    private Supplier<Block>[] blocksSupplier;
    private Block[] blocks;
    private final TagKey<Block> tags;

    @SafeVarargs
    public BaseSaplingBlock(TreeGrower grower, BlockBehaviour.Properties properties, @Nullable TagKey<Block> tags, Supplier<Block> ... block) {
        super(grower, properties);
        this.blocksSupplier = block;
        this.tags = tags;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos below = pPos.below();
        BlockState blockBelow = pLevel.getBlockState(below);
        if (this.blocks == null) {
            this.blocks = (Block[])Arrays.stream(this.blocksSupplier).map(Supplier::get).toArray(Block[]::new);
            this.blocksSupplier = null;
        }
        if (this.blocks.length != 0) {
            if (!Arrays.stream(this.blocks).anyMatch(arg_0 -> ((BlockState)blockBelow).is(arg_0))) return false;
        }
        if (this.tags == null) return true;
        if (!blockBelow.is(this.tags)) return false;
        return true;
    }
}

