/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class ConversionTable {
    protected final Map<BlockState, BlockState> cache = new Object2ObjectOpenHashMap();
    protected boolean allowsAir = false;
    protected BlockState lastCheck;
    protected BlockState lastTarget;

    @Nullable
    public BlockState get(BlockState source) {
        if (!this.allowsAir && source.isAir()) {
            return null;
        }
        if (this.lastTarget != null && source == this.lastCheck) {
            return this.lastTarget;
        }
        BlockState computed = this.cache.computeIfAbsent(source, this::getTargetState);
        if (source != this.lastCheck) {
            this.lastCheck = source;
            this.lastTarget = computed;
        }
        return computed;
    }

    @Nullable
    protected abstract Block getTarget(BlockState var1);

    @Nullable
    protected <T extends Comparable<T>, V extends T> BlockState getTargetState(BlockState source) {
        Block target = this.getTarget(source);
        if (target == null || source.is(target)) {
            return null;
        }
        BlockState targetState = target.defaultBlockState();
        for (Map.Entry entry1 : source.getValues().entrySet()) {
            if (!targetState.hasProperty((Property)entry1.getKey())) continue;
            targetState = (BlockState)targetState.setValue((Property)entry1.getKey(), (Comparable)entry1.getValue());
        }
        return targetState;
    }

    public void clear() {
        this.cache.clear();
    }
}

