/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.natural.LogBlockSet;
import org.confluence.mod.common.block.natural.spreadable.AshConversionTable;
import org.confluence.mod.common.block.natural.spreadable.ConversionTable;
import org.confluence.mod.common.block.natural.spreadable.GlowingMushroomConversionTable;
import org.confluence.mod.common.block.natural.spreadable.JungleConversionTable;
import org.confluence.mod.common.block.natural.spreadable.PureConversionTable;
import org.confluence.mod.common.block.natural.spreadable.TheCorruptionConversionTable;
import org.confluence.mod.common.block.natural.spreadable.TheCrimsonConversionTable;
import org.confluence.mod.common.block.natural.spreadable.TheHallowConversionTable;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISpreadable {
    public static final BooleanProperty STILL_ALIVE = BooleanProperty.create((String)"still_alive");
    public static final Supplier<Set<Block>> PALMS = Suppliers.memoize(() -> {
        LogBlockSet set = NatureBlocks.PALM_LOG_BLOCKS;
        return Sets.newHashSet((Object[])new Block[]{(Block)set.LOG.get(), (Block)set.WOOD.get(), (Block)set.STRIPPED_LOG.get(), (Block)set.STRIPPED_WOOD.get(), (Block)set.LEAVES.get()});
    });
    public static final BlockState AIR = Blocks.AIR.defaultBlockState();

    public Type getSpreadType();

    default public void spread(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!((Boolean)blockState.getValue((Property)STILL_ALIVE)).booleanValue()) {
            return;
        }
        int chance = serverLevel.getGameRules().getInt(Confluence.SPREADABLE_CHANCE);
        int phase = KillBoard.INSTANCE.getGamePhase().getOrder();
        if (phase >= GamePhase.PLANTERA.getOrder()) {
            chance /= 2;
        }
        if (chance != 100 && (chance == 0 || randomSource.nextInt(100) >= chance)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            BlockState target;
            BlockPos targetPos = blockPos.offset(randomSource.nextInt(3) - 1, randomSource.nextInt(5) - 3, randomSource.nextInt(3) - 1);
            if (!serverLevel.isLoaded(targetPos) || (target = this.getSpreadType().getNullable(serverLevel.getBlockState(targetPos))) == null) continue;
            if (target.is(ModTags.Blocks.SPREADABLE_GRASS_BLOCK)) {
                if (this.isFullBlock(serverLevel, targetPos.above())) continue;
                this.spreadOrDie(phase, blockState, serverLevel, blockPos, randomSource, target, targetPos);
                continue;
            }
            this.spreadOrDie(phase, blockState, serverLevel, blockPos, randomSource, target, targetPos);
        }
    }

    default public boolean isFullBlock(ServerLevel serverLevel, BlockPos pos) {
        return Block.isShapeFullBlock((VoxelShape)serverLevel.getBlockState(pos).getCollisionShape((BlockGetter)serverLevel, pos));
    }

    default public void spreadOrDie(int phase, BlockState selfState, ServerLevel serverLevel, BlockPos selfPos, RandomSource randomSource, BlockState targetState, BlockPos targetPos) {
        this.spreadTree(serverLevel, targetPos);
        serverLevel.setBlockAndUpdate(targetPos, targetState);
        if (randomSource.nextInt(7) > phase) {
            serverLevel.setBlockAndUpdate(selfPos, (BlockState)selfState.setValue((Property)STILL_ALIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    default public void spreadTree(ServerLevel serverLevel, BlockPos targetPos) {
        BlockState blockState = serverLevel.getBlockState(targetPos.above());
        if (blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES)) {
            Map<BlockPos, BlockState> map = ISpreadable.searchFace(serverLevel, targetPos, new Hashtable<BlockPos, BlockState>(), 0);
            for (Map.Entry<BlockPos, BlockState> entry : map.entrySet()) {
                BlockState target;
                BlockState source = entry.getValue();
                if (source == AIR || (target = this.getSpreadType().getNullable(source)) == null) continue;
                serverLevel.setBlockAndUpdate(entry.getKey(), target);
            }
        }
    }

    private static Map<BlockPos, BlockState> searchFace(ServerLevel serverLevel, BlockPos targetPos, Map<BlockPos, BlockState> map, int depth) {
        if (depth == 128) {
            return map;
        }
        for (Direction direction : LibUtils.DIRECTIONS) {
            BlockPos relative = targetPos.relative(direction);
            if (map.containsKey(relative)) continue;
            BlockState blockState = serverLevel.getBlockState(relative);
            if (blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES)) {
                map.put(relative, blockState);
                if (PALMS.get().contains(blockState.getBlock())) {
                    ISpreadable.searchBox(serverLevel, relative, map, depth + 1);
                    continue;
                }
                ISpreadable.searchFace(serverLevel, relative, map, depth + 1);
                continue;
            }
            map.put(relative, AIR);
        }
        return map;
    }

    private static void searchBox(ServerLevel serverLevel, BlockPos targetPos, Map<BlockPos, BlockState> map, int depth) {
        if (depth == 128) {
            return;
        }
        for (BlockPos relative : BlockPos.betweenClosed((BlockPos)targetPos.offset(-1, -1, -1), (BlockPos)targetPos.offset(1, 1, 1))) {
            if (map.containsKey(relative)) continue;
            BlockState blockState = serverLevel.getBlockState(relative);
            if (blockState.is(BlockTags.LOGS) || blockState.is(BlockTags.LEAVES)) {
                map.put(relative.immutable(), blockState);
                if (PALMS.get().contains(blockState.getBlock())) {
                    ISpreadable.searchBox(serverLevel, relative, map, depth + 1);
                    continue;
                }
                ISpreadable.searchFace(serverLevel, relative, map, depth + 1);
                continue;
            }
            map.put(relative.immutable(), AIR);
        }
    }

    public static enum Type implements StringRepresentable
    {
        HALLOW(new TheHallowConversionTable()),
        CRIMSON(new TheCrimsonConversionTable()),
        CORRUPT(new TheCorruptionConversionTable()),
        GLOWING(new GlowingMushroomConversionTable()),
        JUNGLE(new JungleConversionTable()),
        PURE(new PureConversionTable()),
        ASH(new AshConversionTable());

        private static final IntFunction<Type> BY_ID;
        private final ConversionTable conversionTable;

        private Type(ConversionTable conversionTable) {
            this.conversionTable = conversionTable;
        }

        @NotNull
        public BlockState getNotNull(BlockState source) {
            BlockState target = this.conversionTable.get(source);
            return target == null ? source : target;
        }

        @Nullable
        public BlockState getNullable(BlockState source) {
            return this.conversionTable.get(source);
        }

        public boolean spread(Level level, BlockPos pos) {
            BlockState target = this.getNullable(level.getBlockState(pos));
            if (target != null) {
                return level.setBlockAndUpdate(pos, target);
            }
            return false;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

