/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.SpreadingGrassBlock;

public class JungleGrassBlock
extends SpreadingGrassBlock
implements BonemealableBlock {
    public JungleGrassBlock(ISpreadable.Type type, BlockBehaviour.Properties properties) {
        super(type, properties.mapColor(DyeColor.byId((int)5884220)));
    }

    @Override
    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        if (!serverLevel.isAreaLoaded(blockPos, 3)) {
            return;
        }
        if (this.isFullBlock(serverLevel, blockPos.above())) {
            serverLevel.setBlockAndUpdate(blockPos, Blocks.MUD.defaultBlockState());
        } else {
            super.randomTick(blockState, serverLevel, blockPos, random);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos startPos = pos.above();
        BlockState shortGrassState = Blocks.SHORT_GRASS.defaultBlockState();
        Optional grassFeatureOpt = serverLevel.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(VegetationPlacements.GRASS_BONEMEAL);
        for (int i = 0; i < 128; ++i) {
            Holder featureHolder;
            BlockPos targetPos = startPos;
            boolean validPosition = true;
            for (int j = 0; j < i / 16; ++j) {
                int offsetX = random.nextInt(3) - 1;
                int offsetY = (random.nextInt(3) - 1) * random.nextInt(3) / 2;
                int offsetZ = random.nextInt(3) - 1;
                targetPos = targetPos.offset(offsetX, offsetY, offsetZ);
                BlockState belowState = serverLevel.getBlockState(targetPos.below());
                BlockState currentState = serverLevel.getBlockState(targetPos);
                if (belowState.is((Block)this) && !currentState.isCollisionShapeFullBlock((BlockGetter)serverLevel, targetPos)) continue;
                validPosition = false;
                break;
            }
            if (!validPosition) continue;
            BlockState targetState = serverLevel.getBlockState(targetPos);
            if (targetState.is(shortGrassState.getBlock()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)shortGrassState.getBlock()).performBonemeal(serverLevel, random, targetPos, targetState);
            }
            if (!targetState.isAir()) continue;
            if (random.nextInt(8) == 0) {
                List flowerFeatures = ((Biome)serverLevel.getBiome(targetPos).value()).getGenerationSettings().getFlowerFeatures();
                if (flowerFeatures.isEmpty()) continue;
                featureHolder = ((RandomPatchConfiguration)((ConfiguredFeature)flowerFeatures.get(0)).config()).feature();
            } else {
                if (!grassFeatureOpt.isPresent()) continue;
                featureHolder = (Holder)grassFeatureOpt.get();
            }
            ((PlacedFeature)featureHolder.value()).place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), random, targetPos);
        }
    }

    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

