/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.SpreadingGrassBlock;
import org.confluence.mod.common.init.block.NatureBlocks;

public class MushroomGrassBlock
extends SpreadingGrassBlock
implements BonemealableBlock {
    public MushroomGrassBlock() {
        super(ISpreadable.Type.GLOWING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD));
    }

    @Override
    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 3)) {
            return;
        }
        if (this.isFullBlock(serverLevel, blockPos.above())) {
            serverLevel.setBlockAndUpdate(blockPos, Blocks.MUD.defaultBlockState());
        } else {
            super.randomTick(blockState, serverLevel, blockPos, randomSource);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        int attempts = 128;
        int range = 4;
        BiConsumer<BlockState, IntUnaryOperator> tryPlaceBlock = (blockState, dyGenerator) -> {
            for (int i = 0; i < 128; ++i) {
                int dx = random.nextInt(9) - 4;
                int dz = random.nextInt(9) - 4;
                int dy = dyGenerator.applyAsInt(random.nextInt(2));
                BlockPos targetPos = pos.offset(dx, dy, dz);
                if (!level.getBlockState(targetPos).isAir() || !blockState.canSurvive((LevelReader)level, targetPos)) continue;
                level.setBlockAndUpdate(targetPos, blockState);
            }
        };
        BlockState glowingMushroom = ((Block)NatureBlocks.GLOWING_MUSHROOM.get()).defaultBlockState();
        BlockState glowingMushroomVine = ((Block)NatureBlocks.GLOWING_MUSHROOM_VINE.get()).defaultBlockState();
        tryPlaceBlock.accept(glowingMushroom, dy -> dy);
        tryPlaceBlock.accept(glowingMushroomVine, dy -> -dy);
    }
}

