/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.SpreadingBlock;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.util.OverworldUtils;

public class PearlstoneBlock
extends SpreadingBlock {
    private static final Direction[] AVAILABLE = new Direction[]{Direction.DOWN, Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST};

    public PearlstoneBlock(BlockBehaviour.Properties properties) {
        super(ISpreadable.Type.HALLOW, properties);
    }

    @Override
    public void spread(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        super.spread(blockState, serverLevel, blockPos, randomSource);
        PearlstoneBlock.generateCrystal(serverLevel, blockPos, randomSource);
    }

    public static void generateCrystal(ServerLevel level, BlockPos pos, RandomSource random) {
        if (pos.getY() <= OverworldUtils.getUndergroundY() && random.nextInt(100) == 0) {
            Direction direction = (Direction)Util.getRandom((Object[])AVAILABLE, (RandomSource)random);
            BlockPos relative = pos.relative(direction);
            AmethystClusterBlock crystalShards = (AmethystClusterBlock)NatureBlocks.CRYSTAL_SHARDS.get();
            if (level.getBlockState(relative).isAir() && level.getBlockStates(new AABB(relative).inflate(3.5)).filter(state -> {
                if (state.liquid() || state.isAir()) {
                    return false;
                }
                return state.is((Block)crystalShards);
            }).count() < 6L) {
                AmethystClusterBlock block = random.nextInt(50) == 0 ? (AmethystClusterBlock)NatureBlocks.GELATIN_CRYSTAL.get() : crystalShards;
                level.setBlockAndUpdate(relative, (BlockState)block.defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction));
            }
        }
    }
}

