/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.common.block.natural.ThornBlock;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;
import org.confluence.mod.common.block.natural.spreadable.SpreadingBlock;
import org.confluence.mod.common.init.block.NatureBlocks;

public class SpreadingGrassBlock
extends SpreadingBlock {
    public SpreadingGrassBlock(ISpreadable.Type type, BlockBehaviour.Properties properties) {
        super(type, properties);
    }

    @Override
    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 3)) {
            return;
        }
        BlockPos above = blockPos.above();
        if (this.isFullBlock(serverLevel, above)) {
            serverLevel.setBlockAndUpdate(blockPos, Blocks.DIRT.defaultBlockState());
        } else {
            ThornBlock thorn;
            switch (this.getSpreadType()) {
                case CRIMSON: {
                    ThornBlock thornBlock = (ThornBlock)((Object)NatureBlocks.CRIMSON_THORN.get());
                    break;
                }
                case CORRUPT: {
                    ThornBlock thornBlock = (ThornBlock)((Object)NatureBlocks.CORRUPTION_THORN.get());
                    break;
                }
                default: {
                    ThornBlock thornBlock = thorn = null;
                }
            }
            if (thorn != null && randomSource.nextInt(50) == 0 && serverLevel.getBlockState(above).isAir() && serverLevel.getBlockState(above.east()).isAir() && serverLevel.getBlockState(above.west()).isAir() && serverLevel.getBlockState(above.south()).isAir() && serverLevel.getBlockState(above.north()).isAir()) {
                serverLevel.setBlockAndUpdate(above, thorn.getStateForPlacement((BlockGetter)serverLevel, above));
            }
            super.randomTick(blockState, serverLevel, blockPos, randomSource);
        }
    }
}

