/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.confluence.mod.common.block.natural.ThornBlock;
import org.confluence.mod.common.block.natural.spreadable.ISpreadable;

public class SpreadingThornBlock
extends ThornBlock
implements ISpreadable {
    private final ISpreadable.Type type;

    public SpreadingThornBlock(float amount, Block ground, ISpreadable.Type type) {
        super(amount, ground);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STILL_ALIVE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STILL_ALIVE});
    }

    @Override
    public ISpreadable.Type getSpreadType() {
        return this.type;
    }

    @Override
    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pLevel.isAreaLoaded(pPos, 3)) {
            return;
        }
        this.spread(pState, pLevel, pPos, pRandom);
        super.randomTick(pState, pLevel, pPos, pRandom);
    }
}

