/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.block.natural.spreadable;

import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.confluence.mod.common.block.natural.CattailsBodyBlock;
import org.confluence.mod.common.block.natural.CattailsHeadBlock;
import org.confluence.mod.common.block.natural.spreadable.ConversionTable;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.jetbrains.annotations.Nullable;

public class TheCorruptionConversionTable
extends ConversionTable {
    @Override
    @Nullable
    protected Block getTarget(BlockState source) {
        Block block = source.getBlock();
        if (block == Blocks.TALL_GRASS) {
            return source.getValue((Property)DoublePlantBlock.HALF) == DoubleBlockHalf.LOWER ? (Block)NatureBlocks.CORRUPT_GRASS.get() : Blocks.AIR;
        }
        if (block instanceof CattailsHeadBlock) {
            return (Block)NatureBlocks.EBONY_CATTAILS_HEAD.get();
        }
        if (block instanceof CattailsBodyBlock) {
            return (Block)NatureBlocks.EBONY_CATTAILS_BODY.get();
        }
        Holder.Reference holder = block.builtInRegistryHolder();
        if (holder.is(BlockTags.LOGS)) {
            return (Block)NatureBlocks.EBONY_LOG_BLOCKS.LOG.get();
        }
        if (holder.is(BlockTags.LEAVES)) {
            return (Block)NatureBlocks.EBONY_LOG_BLOCKS.LEAVES.get();
        }
        if (holder.is(BlockTags.BASE_STONE_OVERWORLD)) {
            return (Block)NatureBlocks.EBONSTONE.get();
        }
        if (holder.is(Tags.Blocks.COBBLESTONES)) {
            return (Block)NatureBlocks.COBBLED_EBONSTONE.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_DIRT)) {
            return Blocks.DIRT;
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_GRASS_BLOCK)) {
            return (Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_JUNGLE_GRASS_BLOCK)) {
            return (Block)NatureBlocks.CORRUPT_JUNGLE_GRASS_BLOCK.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_SHORT_GRASS)) {
            return (Block)NatureBlocks.CORRUPT_GRASS.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_PACKED_ICE)) {
            return (Block)NatureBlocks.PURPLE_PACKED_ICE.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_ICE)) {
            return (Block)NatureBlocks.PURPLE_ICE.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_SAND)) {
            return (Block)NatureBlocks.EBONSAND.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_SANDSTONE)) {
            return (Block)NatureBlocks.EBONSANDSTONE.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_HARDENED_SAND_BLOCK)) {
            return (Block)NatureBlocks.HARDENED_EBONSAND_BLOCK.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_MOIST_SAND_BLOCK)) {
            return (Block)NatureBlocks.MOISTENED_EBONSAND_BLOCK.get();
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_CONVERSION_CACTUS)) {
            return (Block)NatureBlocks.CORRUPT_CACTUS.get();
        }
        if (holder.is(Tags.Blocks.ORES_REDSTONE)) {
            return (Block)OreBlocks.CORRUPTION_REDSTONE_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_COAL)) {
            return (Block)OreBlocks.CORRUPTION_COAL_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_LAPIS)) {
            return (Block)OreBlocks.CORRUPTION_LAPIS_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_RUBY)) {
            return (Block)OreBlocks.CORRUPTION_RUBY_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_AMBER)) {
            return (Block)OreBlocks.CORRUPTION_AMBER_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_TOPAZ)) {
            return (Block)OreBlocks.CORRUPTION_TOPAZ_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_JADE)) {
            return (Block)OreBlocks.CORRUPTION_JADE_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_EMERALD)) {
            return (Block)OreBlocks.CORRUPTION_EMERALD_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_SAPPHIRE)) {
            return (Block)OreBlocks.CORRUPTION_SAPPHIRE_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_AMETHYST)) {
            return (Block)OreBlocks.CORRUPTION_AMETHYST_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_DIAMOND)) {
            return (Block)OreBlocks.CORRUPTION_DIAMOND_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_TIN)) {
            return (Block)OreBlocks.CORRUPTION_TIN_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_COPPER)) {
            return (Block)OreBlocks.CORRUPTION_COPPER_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_IRON)) {
            return (Block)OreBlocks.CORRUPTION_IRON_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_LEAD)) {
            return (Block)OreBlocks.CORRUPTION_LEAD_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_SILVER)) {
            return (Block)OreBlocks.CORRUPTION_SILVER_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_TUNGSTEN)) {
            return (Block)OreBlocks.CORRUPTION_TUNGSTEN_ORE.get();
        }
        if (holder.is(Tags.Blocks.ORES_GOLD)) {
            return (Block)OreBlocks.CORRUPTION_GOLD_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_PLATINUM)) {
            return (Block)OreBlocks.CORRUPTION_PLATINUM_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_DEMONITE)) {
            return (Block)OreBlocks.CORRUPTION_DEMONITE_ORE.get();
        }
        if (holder.is(ModTags.Blocks.ORES_CRIMTANE)) {
            return (Block)OreBlocks.CORRUPTION_CRIMTANE_ORE.get();
        }
        return null;
    }
}

