/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModDataMaps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ValueComponent(int value) implements DataComponentType<ValueComponent>
{
    public static final Codec<ValueComponent> CODEC = Codec.INT.xmap(ValueComponent::new, ValueComponent::value);
    public static final StreamCodec<ByteBuf, ValueComponent> STREAM_CODEC = ByteBufCodecs.INT.map(ValueComponent::new, ValueComponent::value);

    @Nullable
    public Codec<ValueComponent> codec() {
        return CODEC;
    }

    @NotNull
    public StreamCodec<? super RegistryFriendlyByteBuf, ValueComponent> streamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block4: {
            block2: {
                block3: {
                    if (o == this) break block3;
                    if (!(o instanceof ValueComponent)) break block2;
                    ValueComponent valueComponent = (ValueComponent)o;
                    try {
                        int n;
                        int value1 = n = valueComponent.value();
                        if (value1 != this.value) break block2;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static int getValue(ItemStack itemStack, int defaultValue, boolean prototype) {
        ValueComponent value;
        DataComponentType<ValueComponent> type = ModDataComponentTypes.VALUE.get();
        ValueComponent valueComponent = value = prototype ? (ValueComponent)itemStack.getPrototype().get(type) : (ValueComponent)itemStack.get(type);
        if (value == null) {
            value = (ValueComponent)itemStack.getItemHolder().getData(ModDataMaps.VALUE);
            return (value == null ? defaultValue : value.value()) * itemStack.getCount();
        }
        return value.value() * itemStack.getCount();
    }

    public static int getValue(ItemStack itemStack, int defaultValue) {
        return ValueComponent.getValue(itemStack, defaultValue, false);
    }
}

