/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;

public record ExtractinatorData(List<Pool> pools) {
    public static final Codec<ExtractinatorData> CODEC = Pool.CODEC.listOf().xmap(ExtractinatorData::new, ExtractinatorData::pools);

    public static void extract(Level level, BlockPos pos, Player player, InteractionHand hand, ServerLevel serverLevel, ItemStack itemStack, ExtractinatorData data) {
        ItemParticleOption itemParticleOption;
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            itemParticleOption = new BlockParticleOption(ParticleTypes.BLOCK, blockItem.getBlock().defaultBlockState());
        } else {
            itemParticleOption = new ItemParticleOption(ParticleTypes.ITEM, itemStack);
        }
        ItemParticleOption options = itemParticleOption;
        serverLevel.sendParticles((ParticleOptions)options, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.75f), (double)((float)pos.getZ() + 0.5f), 100, 0.0, 0.0625, 0.0, 0.25);
        RandomSource random = player.getRandom();
        for (Pool pool : data.pools) {
            for (ItemStack item2 : pool.getRandomItems(random)) {
                LibUtils.createItemEntity((ItemStack)item2, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 1.0), (double)((double)pos.getZ() + 0.5), (Level)level, (int)40);
            }
        }
        itemStack.shrink(1);
        if (itemStack.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Pool {
        public static final Codec<Pool> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("min_roll", (Object)1).forGetter(pool -> pool.minRoll), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_roll", (Object)1).forGetter(pool -> pool.maxRoll), (App)Entry.CODEC.listOf().fieldOf("entries").forGetter(pool -> pool.entries)).apply((Applicative)instance, Pool::new));
        public final int minRoll;
        public final int maxRoll;
        public final int totalWeight;
        public final ImmutableList<Entry> entries;

        public Pool(int minRoll, int maxRoll, List<Entry> entries) {
            if (maxRoll < minRoll) {
                throw new IllegalArgumentException("minRoll=" + minRoll + " must greater or equals than maxRoll=" + maxRoll);
            }
            if (maxRoll < 0) {
                throw new IllegalArgumentException("maxRoll=" + maxRoll + " must greater or equals than zero");
            }
            this.minRoll = minRoll;
            this.maxRoll = maxRoll;
            this.totalWeight = WeightedRandom.getTotalWeight(entries);
            if (this.totalWeight == 0) {
                throw new IllegalArgumentException("Invalid entries, which total weight is 0");
            }
            this.entries = ImmutableList.copyOf(entries);
        }

        public Pool(Entry ... entries) {
            this(1, 1, Arrays.stream(entries).toList());
        }

        public List<ItemStack> getRandomItems(RandomSource random) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            int i = this.minRoll == this.maxRoll ? this.minRoll : Mth.randomBetweenInclusive((RandomSource)random, (int)this.minRoll, (int)this.maxRoll);
            for (int j = 0; j < i; ++j) {
                WeightedRandom.getWeightedItem(this.entries, (int)random.nextInt(this.totalWeight)).ifPresent(entry -> {
                    ItemStack itemStack = entry.randomItem(random);
                    if (!itemStack.isEmpty()) {
                        itemStacks.add(itemStack);
                    }
                });
            }
            return itemStacks;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private int minRoll = 1;
            private int maxRoll = 1;
            private final List<Entry> entries = new ArrayList<Entry>();

            public Builder setRolls(int minRoll, int maxRoll) {
                this.minRoll = minRoll;
                this.maxRoll = maxRoll;
                return this;
            }

            public Builder setRolls(int rolls) {
                this.minRoll = this.maxRoll = rolls;
                return this;
            }

            public Builder add(Entry entry) {
                this.entries.add(entry);
                return this;
            }

            public Pool build() {
                return new Pool(this.minRoll, this.maxRoll, this.entries);
            }
        }
    }

    public static class Builder {
        private final List<Pool> pools = new ArrayList<Pool>();

        public Builder withPool(Pool pool) {
            this.pools.add(pool);
            return this;
        }

        public Builder withPool(Pool.Builder pool) {
            this.pools.add(pool.build());
            return this;
        }

        public ExtractinatorData build() {
            return new ExtractinatorData(this.pools);
        }
    }

    public static class Entry
    implements WeightedEntry {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().lenientOptionalFieldOf("item", (Object)Items.AIR).forGetter(entry -> entry.item), (App)Codec.INT.lenientOptionalFieldOf("min_count", (Object)1).forGetter(entry -> entry.minCount), (App)Codec.INT.lenientOptionalFieldOf("max_count", (Object)1).forGetter(entry -> entry.maxCount), (App)Weight.CODEC.lenientOptionalFieldOf("weight", (Object)Weight.of((int)1)).forGetter(Entry::getWeight)).apply((Applicative)instance, Entry::new));
        public final Item item;
        public final int minCount;
        public final int maxCount;
        public final Weight weight;

        public Entry(Item item, int minCount, int maxCount, Weight weight) {
            if (maxCount < minCount) {
                throw new IllegalArgumentException("minCount=" + minCount + " must greater or equals than maxCount=" + maxCount);
            }
            if (maxCount < 0) {
                throw new IllegalArgumentException("maxCount=" + maxCount + " must greater or equals than zero");
            }
            this.item = item;
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.weight = weight;
        }

        public Entry(Item item, int minCount, int maxCount, int weight) {
            this(item, minCount, maxCount, Weight.of((int)weight));
        }

        public ItemStack randomItem(RandomSource randomSource) {
            if (this.item == Items.AIR) {
                return ItemStack.EMPTY;
            }
            return new ItemStack((ItemLike)this.item, this.minCount == this.maxCount ? this.minCount : Mth.randomBetweenInclusive((RandomSource)randomSource, (int)this.minCount, (int)this.maxCount));
        }

        public Weight getWeight() {
            return this.weight;
        }

        public boolean isEmpty() {
            return this.item == Items.AIR;
        }

        public static Entry empty(Weight weight) {
            return new Entry(Items.AIR, 1, 1, weight);
        }

        public static Entry empty(int weight) {
            return new Entry(Items.AIR, 1, 1, weight);
        }

        public static Entry of(ItemLike item, int minCount, int maxCount, int weight) {
            return new Entry(item.asItem(), minCount, maxCount, weight);
        }

        public static Entry of(ItemLike item, int count, int weight) {
            return new Entry(item.asItem(), count, count, weight);
        }
    }
}

