/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModDataMaps;
import org.confluence.terra_curio.api.primitive.AttributeModifiersValue;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public record GamePhase2AttributeModifiers(Map<GamePhase, AttributeModifiersValue> map) {
    public static final Codec<GamePhase2AttributeModifiers> CODEC = Codec.unboundedMap(GamePhase.CODEC, (Codec)AttributeModifiersValue.CODEC).xmap(GamePhase2AttributeModifiers::new, GamePhase2AttributeModifiers::map);

    public AttributeModifiersValue get(GamePhase gamePhase) {
        AttributeModifiersValue value = this.map.get((Object)gamePhase);
        return value == null ? this.map.keySet().stream().filter(gamePhase::isAtLeast).max(Comparator.comparingInt(GamePhase::getOrder)).map(this.map::get).orElse(AttributeModifiersValue.EMPTY) : value;
    }

    public static void applyModifiers(LivingEntity living) {
        if (living instanceof Player) {
            return;
        }
        Difficulty difficulty = living.level().getDifficulty();
        if (difficulty == Difficulty.PEACEFUL || difficulty == Difficulty.EASY) {
            return;
        }
        GamePhase2AttributeModifiers data = (GamePhase2AttributeModifiers)ModDataMaps.getEntityData(ModDataMaps.GAME_PHASE_2_ATTRIBUTE_MODIFIERS, (Entity)living);
        if (data == null) {
            return;
        }
        ImmutableListMultimap modifiers = data.get(KillBoard.INSTANCE.getGamePhase()).get();
        if (modifiers.isEmpty()) {
            return;
        }
        for (Map.Entry entry : modifiers.asMap().entrySet()) {
            AttributeInstance instance = living.getAttribute((Holder)entry.getKey());
            if (instance == null) continue;
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                instance.addOrReplacePermanentModifier(modifier);
            }
        }
        living.setHealth(living.getMaxHealth());
    }

    public static class Merger
    implements DataMapValueMerger<EntityType<?>, GamePhase2AttributeModifiers> {
        public GamePhase2AttributeModifiers merge(Registry<EntityType<?>> registry, Either<TagKey<EntityType<?>>, ResourceKey<EntityType<?>>> first, GamePhase2AttributeModifiers firstValue, Either<TagKey<EntityType<?>>, ResourceKey<EntityType<?>>> second, GamePhase2AttributeModifiers secondValue) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Stream.concat(firstValue.map.keySet().stream(), secondValue.map.keySet().stream()).distinct().forEach(gamePhase -> {
                AttributeModifiersValue.Builder builder1 = AttributeModifiersValue.builder();
                AttributeModifiersValue value = firstValue.map.get(gamePhase);
                if (value != null) {
                    builder1.addAll((Multimap)value.get());
                }
                if ((value = secondValue.map.get(gamePhase)) != null) {
                    builder1.addAll((Multimap)value.get());
                }
                builder.put((Object)gamePhase, (Object)builder1.build());
            });
            return new GamePhase2AttributeModifiers((Map<GamePhase, AttributeModifiersValue>)builder.build());
        }
    }

    public record Remover(Map<GamePhase, ImmutableListMultimap<Holder<Attribute>, ResourceLocation>> map) implements DataMapValueRemover<EntityType<?>, GamePhase2AttributeModifiers>
    {
        public static final Codec<Remover> CODEC = Codec.unboundedMap(GamePhase.CODEC, (Codec)LibCodecUtils.multimapCodec((Codec)Attribute.CODEC, (Codec)ResourceLocation.CODEC)).xmap(Remover::new, Remover::map);

        public Optional<GamePhase2AttributeModifiers> remove(GamePhase2AttributeModifiers value, Registry<EntityType<?>> registry, Either<TagKey<EntityType<?>>, ResourceKey<EntityType<?>>> source, EntityType<?> object) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<GamePhase, ImmutableListMultimap<Holder<Attribute>, ResourceLocation>> entry : this.map.entrySet()) {
                ImmutableListMultimap multimap = value.map.getOrDefault((Object)entry.getKey(), AttributeModifiersValue.EMPTY).get();
                if (multimap.isEmpty()) continue;
                AttributeModifiersValue.Builder builder1 = AttributeModifiersValue.builder();
                for (Map.Entry entry1 : entry.getValue().asMap().entrySet()) {
                    ImmutableList modifiers = multimap.get((Object)((Holder)entry1.getKey()));
                    if (modifiers.isEmpty()) continue;
                    for (ResourceLocation id : (Collection)entry1.getValue()) {
                        for (AttributeModifier modifier : modifiers) {
                            if (modifier.id().equals((Object)id)) continue;
                            builder1.add((Holder)entry1.getKey(), new AttributeModifier[]{modifier});
                        }
                    }
                }
                AttributeModifiersValue value1 = builder1.build();
                if (value1.isEmpty()) continue;
                builder.put((Object)entry.getKey(), (Object)value1);
            }
            ImmutableMap map1 = builder.build();
            return map1.isEmpty() ? Optional.empty() : Optional.of(new GamePhase2AttributeModifiers((Map<GamePhase, AttributeModifiersValue>)map1));
        }
    }
}

