/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.map;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.confluence.mod.common.init.ModDataMaps;

public record LivingInvulnerableEffects(HolderSet<MobEffect> effects, List<Category> categories) {
    public static final Codec<LivingInvulnerableEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.create((ResourceKey)Registries.MOB_EFFECT, (Codec)MobEffect.CODEC, (boolean)false).fieldOf("effects").forGetter(LivingInvulnerableEffects::effects), (App)Category.CODEC.listOf().lenientOptionalFieldOf("category", List.of()).forGetter(LivingInvulnerableEffects::categories)).apply((Applicative)instance, LivingInvulnerableEffects::new));

    public LivingInvulnerableEffects(HolderSet<MobEffect> effects, Category ... categories) {
        this(effects, Arrays.stream(categories).toList());
    }

    public static boolean isInvulnerableTo(LivingEntity living, Holder<MobEffect> effect) {
        LivingInvulnerableEffects data = ModDataMaps.getEntityData(ModDataMaps.LIVING_INVULNERABLE_EFFECTS, (Entity)living);
        return data != null && data.effects.contains(effect) && (data.categories.isEmpty() || data.categories.stream().anyMatch(category -> category.is(effect)));
    }

    public static enum Category implements StringRepresentable
    {
        BENEFICIAL(MobEffectCategory.BENEFICIAL),
        HARMFUL(MobEffectCategory.HARMFUL),
        NEUTRAL(MobEffectCategory.NEUTRAL);

        public static final Codec<Category> CODEC;
        private final MobEffectCategory value;

        private Category(MobEffectCategory value) {
            this.value = value;
        }

        public boolean is(Holder<MobEffect> effect) {
            return this.value == ((MobEffect)effect.value()).getCategory();
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Category::values);
        }
    }
}

