/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.confluence.lib.common.data.saved.IGlobalData;
import org.confluence.mod.api.event.bestiary.RegisterBestiaryKeyEvent;
import org.confluence.mod.api.event.bestiary.ToBeBestiaryEntryEvent;
import org.confluence.mod.common.data.map.PresetBestiaryEntry;
import org.confluence.mod.common.data.saved.BestiaryEntry;
import org.confluence.mod.network.s2c.BestiarySyncPacketS2C;
import org.confluence.mod.util.ModUtils;

public class Bestiary
implements IGlobalData {
    public static final Codec<Map<String, BestiaryEntry>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, BestiaryEntry.CODEC);
    public static final Bestiary INSTANCE = new Bestiary();
    private final Map<String, BestiaryEntry> entries = Maps.newHashMap();

    private Bestiary() {
    }

    public <T> void decode(Dynamic<T> tag) {
        this.entries.clear();
        tag.get("entries").orElseEmptyMap().read(CODEC).ifSuccess(this.entries::putAll);
    }

    public void encode(CompoundTag tag) {
        tag.put("entries", CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.entries).result().orElseGet(CompoundTag::new));
    }

    public String serializeKey() {
        return "confluence:bestiary";
    }

    public Map<String, BestiaryEntry> getEntries() {
        return this.entries;
    }

    public int getUnlockedCount() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    public BestiaryEntry getOrCreateEntry(LivingEntity living) {
        return this.entries.computeIfAbsent(RegisterBestiaryKeyEvent.getKey(living), key -> {
            BestiaryEntry entry = PresetBestiaryEntry.getEntry(living);
            if (entry != null) {
                return entry;
            }
            entry = new BestiaryEntry();
            entry.type = living.getType();
            entry.key = key;
            AttributeMap map = living.getAttributes();
            entry.maxHealth = Bestiary.getAttributeBaseValue(map, (Holder<Attribute>)Attributes.MAX_HEALTH);
            entry.knockbackResistance = Bestiary.getAttributeBaseValue(map, (Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE);
            entry.attackDamage = Bestiary.getAttributeBaseValue(map, (Holder<Attribute>)Attributes.ATTACK_DAMAGE);
            entry.armor = Bestiary.getAttributeBaseValue(map, (Holder<Attribute>)Attributes.ARMOR);
            entry.drops = living instanceof Enemy ? (int)ModUtils.getLivingBaseMoneyDrops(living, living.level()) : 0;
            return entry;
        });
    }

    public void updateEntry(LivingEntity living, boolean killed) {
        if (((ToBeBestiaryEntryEvent)NeoForge.EVENT_BUS.post((Event)new ToBeBestiaryEntryEvent(living))).isCanceled()) {
            return;
        }
        BestiaryEntry entry = this.getOrCreateEntry(living);
        if (killed) {
            ++entry.killedByCount;
        }
        if (entry.killedByCount > 1) {
            BestiarySyncPacketS2C.syncEntry(living);
        } else {
            BestiarySyncPacketS2C.syncEntry(living, entry);
        }
    }

    public boolean containsKey(LivingEntity living) {
        return this.entries.containsKey(RegisterBestiaryKeyEvent.getKey(living));
    }

    private static float getAttributeBaseValue(AttributeMap map, Holder<Attribute> attribute) {
        AttributeInstance instance = map.getInstance(attribute);
        return instance == null ? 0.0f : (float)instance.getBaseValue();
    }
}

