/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EntityType;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.PlayerUtils;

public class BestiaryEntry {
    public static final Codec<BestiaryEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(BestiaryEntry::getType), (App)Codec.INT.fieldOf("killed_by_count").forGetter(BestiaryEntry::getKilledByCount), (App)Codec.FLOAT.fieldOf("max_health").forGetter(BestiaryEntry::getMaxHealth), (App)Codec.FLOAT.fieldOf("knockback_resistance").forGetter(BestiaryEntry::getKnockbackResistance), (App)Codec.FLOAT.fieldOf("attack_damage").forGetter(BestiaryEntry::getAttackDamage), (App)Codec.FLOAT.fieldOf("armor").forGetter(BestiaryEntry::getArmor), (App)Codec.INT.fieldOf("drops").forGetter(BestiaryEntry::getDrops)).apply((Applicative)instance, BestiaryEntry::new));
    public static final StreamCodec<ByteBuf, BestiaryEntry> STREAM_CODEC = LibStreamCodecUtils.composite((StreamCodec)LibStreamCodecUtils.registry((Registry)BuiltInRegistries.ENTITY_TYPE), BestiaryEntry::getType, (StreamCodec)ByteBufCodecs.VAR_INT, BestiaryEntry::getKilledByCount, (StreamCodec)ByteBufCodecs.FLOAT, BestiaryEntry::getMaxHealth, (StreamCodec)ByteBufCodecs.FLOAT, BestiaryEntry::getKnockbackResistance, (StreamCodec)ByteBufCodecs.FLOAT, BestiaryEntry::getAttackDamage, (StreamCodec)ByteBufCodecs.FLOAT, BestiaryEntry::getArmor, (StreamCodec)ByteBufCodecs.VAR_INT, BestiaryEntry::getDrops, BestiaryEntry::new);
    public EntityType<?> type;
    public int killedByCount;
    public float maxHealth;
    public float knockbackResistance;
    public float attackDamage;
    public float armor;
    public int drops;
    public transient String key;
    private transient Coins coins;

    public BestiaryEntry() {
    }

    private BestiaryEntry(EntityType<?> type, int killedByCount, float maxHealth, float knockbackResistance, float attackDamage, float armor, int drops) {
        this.type = type;
        this.killedByCount = killedByCount;
        this.maxHealth = maxHealth;
        this.knockbackResistance = knockbackResistance;
        this.attackDamage = attackDamage;
        this.armor = armor;
        this.drops = drops;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public int getKilledByCount() {
        return this.killedByCount;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public float getArmor() {
        return this.armor;
    }

    public int getDrops() {
        return this.drops;
    }

    public Coins getCoins() {
        if (this.coins == null) {
            this.coins = PlayerUtils.decodeCoin(this.drops);
        }
        return this.coins;
    }

    public BestiaryEntry copy() {
        BestiaryEntry entry = new BestiaryEntry(this.type, this.killedByCount, this.maxHealth, this.knockbackResistance, this.attackDamage, this.armor, this.drops);
        entry.key = this.key;
        return entry;
    }

    public static Builder builder(EntityType<?> type, String key) {
        return new Builder(type, key);
    }

    public static class Builder {
        private final EntityType<?> type;
        private final String key;
        private float maxHealth;
        private float knockbackResistance;
        private float attackDamage;
        private float armor;
        private int drops;

        private Builder(EntityType<?> type, String key) {
            this.type = type;
            this.key = key;
        }

        public Builder maxHealth(float maxHealth) {
            this.maxHealth = maxHealth;
            return this;
        }

        public Builder knockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        public Builder attackDamage(float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder armor(float armor) {
            this.armor = armor;
            return this;
        }

        public Builder drops(int drops) {
            this.drops = drops;
            return this;
        }

        public BestiaryEntry build() {
            BestiaryEntry entry = new BestiaryEntry(this.type, 0, this.maxHealth, this.knockbackResistance, this.attackDamage, this.armor, this.drops);
            entry.key = this.key;
            return entry;
        }
    }
}

