/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.confluence.mod.util.ModUtils;
import org.confluence.mod.util.OverworldUtils;
import org.confluence.terraentity.entity.boss.AbstractTerraBossBase;

public final class BossDelaySpawner {
    public static final BossDelaySpawner INSTANCE = new BossDelaySpawner();
    private final List<Delayed<AbstractTerraBossBase>> bossQueue = new ArrayList<Delayed<AbstractTerraBossBase>>();

    private BossDelaySpawner() {
    }

    public void tick(ServerLevel serverLevel) {
        if (!this.bossQueue.isEmpty()) {
            this.bossQueue.removeIf(mobDelayed -> {
                if (mobDelayed.delay-- <= 0 && mobDelayed.predicate.test(serverLevel)) {
                    serverLevel.players().stream().filter(player -> player.getY() > (double)OverworldUtils.getSurfaceY()).findAny().ifPresentOrElse(player -> ModUtils.summonBoss(serverLevel, player.blockPosition(), (AbstractTerraBossBase)mobDelayed.entity), () -> {
                        mobDelayed.delay = 20;
                    });
                    return mobDelayed.delay <= 0;
                }
                return false;
            });
        }
    }

    public void pushBoss(int delay, AbstractTerraBossBase boss, Predicate<ServerLevel> predicate) {
        if (this.bossQueue.size() == 8) {
            this.bossQueue.removeFirst();
        }
        this.bossQueue.add(new Delayed<AbstractTerraBossBase>(delay, boss, predicate));
    }

    public boolean hasSameTypeInQueue(EntityType<?> type) {
        return this.bossQueue.stream().anyMatch(delayed -> ((AbstractTerraBossBase)delayed.entity).getType() == type);
    }

    public void clear() {
        this.bossQueue.clear();
    }

    static class Delayed<E extends Entity> {
        int delay;
        final E entity;
        final Predicate<ServerLevel> predicate;

        Delayed(int delay, E entity, Predicate<ServerLevel> predicate) {
            this.delay = delay;
            this.entity = entity;
            this.predicate = predicate;
        }
    }
}

