/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public record BrushData(Map<BlockPos, int[]> colors) {
    public static final int EMPTY_COLOR = -1;
    public static final int CLEAR_COLOR = -2;
    public static final int NEGATIVE_COLOR = -3;
    public static final int ILLUMINANT_COLOR = -4;
    public static final int ECHO_COLOR = -5;
    public static final Function<BlockPos, int[]> COMPUTE = pos -> BrushData.createColor(-1);

    public BrushData(BlockPos pos, @Nullable Direction facing, int color) {
        this((Map)Util.make(new Hashtable(), map -> {
            int[] colors;
            if (facing == null) {
                colors = BrushData.createColor(color);
            } else {
                colors = BrushData.createColor(-1);
                colors[facing.get3DDataValue()] = color;
            }
            map.put(pos, colors);
        }));
    }

    public int @Nullable [] get(BlockPos pos) {
        return this.colors.get(pos);
    }

    public int get(BlockPos pos, Direction facing) {
        int[] list = this.colors.get(pos);
        return list == null ? -1 : list[facing.get3DDataValue()];
    }

    public int getOrDefault(BlockPos pos, Direction facing, int defaultColor) {
        int[] list = this.colors.get(pos);
        return list == null ? defaultColor : list[facing.get3DDataValue()];
    }

    public void put(BlockPos pos, int[] color) {
        int[] list = this.colors.get(pos);
        if (list == null) {
            this.colors.put(pos, color);
        } else {
            System.arraycopy(color, 0, list, 0, 6);
        }
    }

    public void put(BlockPos pos, Direction facing, int color) {
        int[] colors = this.colors.computeIfAbsent(pos, COMPUTE);
        if (color == -5) {
            Arrays.fill(colors, -5);
        } else {
            if (colors[0] == -5) {
                Arrays.fill(colors, -1);
            }
            colors[facing.get3DDataValue()] = color;
        }
    }

    public void merge(BrushData data) {
        for (Map.Entry<BlockPos, int[]> entry : data.colors.entrySet()) {
            BlockPos pos = entry.getKey();
            int[] list = this.colors.get(pos);
            int[] color = entry.getValue();
            if (list == null) {
                this.colors.put(pos, color);
                continue;
            }
            if (!Arrays.stream(color).anyMatch(c -> c != -1)) continue;
            if (list[0] == -5) {
                Arrays.fill(list, -1);
            }
            for (int i = 0; i < 6; ++i) {
                int c2 = color[i];
                if (c2 == -1) continue;
                list[i] = c2;
            }
        }
    }

    public boolean remove(BlockPos pos) {
        return this.colors.remove(pos) != null;
    }

    public boolean remove(BlockPos pos, Direction facing) {
        boolean b;
        int[] list = this.colors.get(pos);
        if (list == null) {
            return false;
        }
        int index = facing.get3DDataValue();
        boolean bl = b = list[index] != -1;
        if (list[index] != -5) {
            list[index] = -1;
            for (int c : list) {
                if (c == -1) continue;
                return b;
            }
        }
        this.colors.remove(pos);
        return b;
    }

    public void ensureValid(ServerLevel serverLevel) {
        this.colors.entrySet().removeIf(entry -> serverLevel.isLoaded((BlockPos)entry.getKey()) && serverLevel.getBlockState((BlockPos)entry.getKey()).isEmpty());
    }

    public static int[] createColor(int color) {
        return new int[]{color, color, color, color, color, color};
    }

    public static int[] rotateColor(int[] colors, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return colors;
        }
        int[] rotated = new int[6];
        for (int i = 0; i < 6; ++i) {
            int j = rotation.rotate(Direction.from3DDataValue((int)i)).get3DDataValue();
            rotated[j] = colors[i];
        }
        return rotated;
    }
}

