/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.data.saved;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.saveddata.SavedData;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.data.saved.MeteoriteTracker;
import org.confluence.mod.common.data.saved.StarPhase;
import org.confluence.mod.network.s2c.MeteoriteLocationPacketS2C;
import org.confluence.mod.network.s2c.StarPhasesPacketS2C;
import org.confluence.mod.network.s2c.WindSpeedPacketS2C;
import org.confluence.phase_journey.common.util.PhaseUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public final class ConfluenceData
extends SavedData {
    public static final int STAR_PHASES_SIZE = 10;
    private boolean initialized = false;
    private final Vector3f windSpeed = new Vector3f();
    private final Int2ObjectMap<StarPhase> starPhases = new Int2ObjectArrayMap();
    private int revealStep = -1;
    private final MeteoriteTracker meteoriteTracker = MeteoriteTracker.INSTANCE;
    private int evilBrokenCount = 0;

    ConfluenceData() {
        for (int i = 0; i < 10; ++i) {
            this.starPhases.put(i, (Object)StarPhase.DEFAULT);
        }
    }

    ConfluenceData(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        this.initialized = nbt.getBoolean("initialized");
        this.windSpeed.x = nbt.getFloat("windSpeedX");
        this.windSpeed.z = nbt.getFloat("windSpeedZ");
        for (Tag tag : nbt.getList("starPhases", 10)) {
            CompoundTag phase = (CompoundTag)tag;
            this.starPhases.put(phase.getInt("index"), (Object)new StarPhase(phase));
        }
        this.revealStep = nbt.getInt("revealStep");
        this.meteoriteTracker.deserialize(nbt);
        this.evilBrokenCount = nbt.getInt("evilBrokenCount");
    }

    public static ConfluenceData get(ServerLevel serverLevel) {
        ConfluenceData data = (ConfluenceData)serverLevel.getDataStorage().computeIfAbsent(new SavedData.Factory(ConfluenceData::new, ConfluenceData::new), "confluence");
        ConfluenceData.initialize(serverLevel, data);
        return data;
    }

    private static void initialize(ServerLevel serverLevel, ConfluenceData data) {
        if (!data.initialized) {
            int i;
            LegacyRandomSource random = new LegacyRandomSource(serverLevel.getSeed());
            ArrayList<Float> raList = new ArrayList<Float>();
            int wEarth = 3 + random.nextInt(3);
            float up = (float)Math.pow(5.0, 1.0 / (double)(wEarth - 1));
            float low = (float)Math.pow(9.0, 1.0 / (double)(10 - wEarth));
            float q = Mth.nextFloat((RandomSource)random, (float)1.2f, (float)Math.min(up, low));
            for (i = 0; i < 10; ++i) {
                float Q = (float)(i < wEarth - 1 ? 1.0 / Math.pow(q, wEarth - 1 - i) : (double)q * Math.pow(q, i + 2 - wEarth));
                float ra = 100.0f * Q;
                raList.add(random.nextInt(raList.size() + 1), Float.valueOf(ra += random.nextFloat() * (ra * 0.1f) * (float)(random.nextBoolean() ? 1 : -1)));
            }
            for (i = 0; i < 10; ++i) {
                data.starPhases.put(i, (Object)new StarPhase(180 - random.nextInt(361), ((Float)raList.get(i)).floatValue(), 20.0f - random.nextFloat() * 40.0f));
            }
            data.initialized = true;
            data.setDirty();
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        nbt.putBoolean("initialized", this.initialized);
        nbt.putFloat("windSpeedX", this.windSpeed.x);
        nbt.putFloat("windSpeedZ", this.windSpeed.z);
        ListTag listTag = new ListTag();
        for (int i = 0; i < 10; ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("index", i);
            ((StarPhase)this.starPhases.getOrDefault(i, (Object)StarPhase.DEFAULT)).writeTo(tag);
            listTag.add((Object)tag);
        }
        nbt.put("starPhases", (Tag)listTag);
        nbt.putInt("revealStep", this.revealStep);
        this.meteoriteTracker.serialize(nbt);
        nbt.putInt("evilBrokenCount", this.evilBrokenCount);
        return nbt;
    }

    public void setWindSpeed(float x, float z) {
        this.windSpeed.x = x;
        this.windSpeed.z = z;
        WindSpeedPacketS2C.sendToAll(x, z);
        this.setDirty();
    }

    public float getWindSpeedX() {
        return this.windSpeed.x;
    }

    public float getWindSpeedZ() {
        return this.windSpeed.z;
    }

    public boolean setStarPhase(int index, int timeOffset, float radius, float angle) {
        if (index >= 10 || !((Boolean)CommonConfigs.STAR_PHASE.get()).booleanValue()) {
            return false;
        }
        this.starPhases.put(index, (Object)new StarPhase(timeOffset, radius, angle));
        StarPhasesPacketS2C.sendToAll(index, timeOffset, radius, angle);
        this.setDirty();
        return true;
    }

    public StarPhase getStarPhase(int index) {
        if (index >= 10 || !((Boolean)CommonConfigs.STAR_PHASE.get()).booleanValue()) {
            return null;
        }
        return (StarPhase)this.starPhases.getOrDefault(index, (Object)StarPhase.DEFAULT);
    }

    public Int2ObjectMap<StarPhase> getStarPhases() {
        return this.starPhases;
    }

    public boolean increaseRevealStep(ServerLevel serverLevel) {
        if (this.revealStep < 8) {
            serverLevel.players().forEach(player -> PhaseUtils.achievePlayerPhase((ServerPlayer)player, (ResourceLocation)Confluence.asResource("reveal_step_" + ++this.revealStep), (boolean)true));
            this.setDirty();
            return true;
        }
        return false;
    }

    public int getRevealStep() {
        return this.revealStep;
    }

    public void setMeteorite(BlockPos location, int tickUntilLanding) {
        this.meteoriteTracker.location = location;
        this.meteoriteTracker.tickUntilLanding = tickUntilLanding;
        MeteoriteLocationPacketS2C.sendToAll(location, tickUntilLanding);
        this.setDirty();
    }

    public BlockPos getMeteoriteLocation() {
        return this.meteoriteTracker.location;
    }

    public boolean updateEvilBrokenCount() {
        ++this.evilBrokenCount;
        this.setDirty();
        return this.evilBrokenCount % 3 == 0;
    }

    public int getEvilBrokenCount() {
        return this.evilBrokenCount;
    }
}

