/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.effect.flask;

import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.Tags;
import org.confluence.mod.common.init.ModEffects;

public abstract class FlaskEffect
extends MobEffect {
    public FlaskEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public FlaskEffect(MobEffectCategory category, int color, ParticleOptions particle) {
        super(category, color, particle);
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
        super.fillEffectCures(cures, effectInstance);
        cures.add(ModEffects.FLASK);
    }

    public abstract void doMeleeAttack(LivingEntity var1, LivingEntity var2, int var3, DamageSource var4, float var5);

    public static void onLivingDamage(LivingEntity victim, Entity attacker, DamageSource damageSource, float amount) {
        LivingEntity living;
        if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker).getWeaponItem().is(Tags.Items.MELEE_WEAPON_TOOLS)) {
            for (MobEffectInstance activeEffect : living.getActiveEffects()) {
                Object object = activeEffect.getEffect().value();
                if (!(object instanceof FlaskEffect)) continue;
                FlaskEffect flaskEffect = (FlaskEffect)((Object)object);
                flaskEffect.doMeleeAttack(living, victim, activeEffect.getAmplifier(), damageSource, amount);
            }
        }
    }

    public static boolean saveFlaskEffects(Map<Holder<MobEffect>, MobEffectInstance> activeEffects) {
        activeEffects.entrySet().removeIf(entry -> !((MobEffectInstance)entry.getValue()).getCures().contains(ModEffects.FLASK));
        return false;
    }

    public static void removeAnotherFlaskEffects(MobEffectInstance mobEffectInstance, LivingEntity living) {
        if (mobEffectInstance.getCures().contains(ModEffects.FLASK)) {
            living.removeEffectsCuredBy(ModEffects.FLASK);
        }
    }
}

